/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.io.IOException;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.aux.MicromissileDefaults;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateMicromissileSettings {
    private float topSpeed;
    private float accel;
    private float damage;
    private PointXY point;
    private String entityFilter;
    private ItemMicromissiles.FireMode fireMode;
    private boolean saveDefault;
    private Hand hand;

    public PacketUpdateMicromissileSettings() {
    }

    public PacketUpdateMicromissileSettings(float topSpeed, float accel, float damage, PointXY point, String entityFilter, ItemMicromissiles.FireMode fireMode, boolean saveDefault, Hand hand) {
        this.topSpeed = topSpeed;
        this.accel = accel;
        this.damage = damage;
        this.point = point;
        this.entityFilter = entityFilter;
        this.fireMode = fireMode;
        this.saveDefault = saveDefault;
        this.hand = hand;
    }

    PacketUpdateMicromissileSettings(PacketBuffer buffer) {
        this.topSpeed = buffer.readFloat();
        this.accel = buffer.readFloat();
        this.damage = buffer.readFloat();
        this.point = new PointXY(buffer.readInt(), buffer.readInt());
        this.entityFilter = buffer.func_150789_c(Short.MAX_VALUE);
        this.fireMode = ItemMicromissiles.FireMode.values()[buffer.readByte()];
        this.saveDefault = buffer.readBoolean();
        this.hand = buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFloat(this.topSpeed);
        buf.writeFloat(this.accel);
        buf.writeFloat(this.damage);
        buf.writeInt(this.point.x);
        buf.writeInt(this.point.y);
        buf.func_180714_a(this.entityFilter);
        buf.writeByte(this.fireMode.ordinal());
        buf.writeBoolean(this.saveDefault);
        buf.writeBoolean(this.hand == Hand.MAIN_HAND);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = player.func_184586_b(this.hand);
            if (!stack.func_190926_b()) {
                this.applySettings((PlayerEntity)player, stack);
            } else {
                Log.warning("Received PacketUpdateMicromissileSettings but player does not hold a Micromissile? " + player.func_200200_C_(), new Object[0]);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void applySettings(PlayerEntity player, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74776_a("turnSpeed", this.accel);
        tag.func_74776_a("topSpeed", this.topSpeed);
        tag.func_74776_a("damage", this.damage);
        tag.func_74768_a("px", this.point.x);
        tag.func_74768_a("py", this.point.y);
        tag.func_74778_a("filter", this.entityFilter);
        tag.func_74778_a("fireMode", this.fireMode.toString());
        if (this.saveDefault) {
            try {
                MicromissileDefaults.INSTANCE.setDefaults(player, new MicromissileDefaults.Entry(this.topSpeed, this.accel, this.damage, this.point, this.entityFilter, this.fireMode));
                MicromissileDefaults.INSTANCE.writeToFile();
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.CHIRP.get(), SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f, false), (ServerPlayerEntity)player);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

