/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdatePressureBlock
extends LocationIntPacket {
    private int currentAir;

    public PacketUpdatePressureBlock() {
    }

    public PacketUpdatePressureBlock(TileEntityPneumaticBase te) {
        super(te.func_174877_v());
        this.currentAir = (Integer)te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).map(IAirHandler::getAir).orElseThrow(RuntimeException::new);
    }

    public PacketUpdatePressureBlock(PacketBuffer buffer) {
        super(buffer);
        this.currentAir = buffer.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeInt(this.currentAir);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = ClientUtils.getClientTE(this.pos);
            te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> h.addAir(this.currentAir - h.getAir()));
        });
        ctx.get().setPacketHandled(true);
    }
}

