/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ProgWidget
implements IProgWidget {
    private final ProgWidgetType<?> type;
    private int x;
    private int y;
    private IProgWidget[] connectedParameters;
    private IProgWidget outputStepConnection;
    private IProgWidget parent;

    public ProgWidget(ProgWidgetType<?> type) {
        this.type = type;
        if (!this.getParameters().isEmpty()) {
            this.connectedParameters = new IProgWidget[this.getParameters().size() * 2];
        }
    }

    @Override
    public ProgWidgetType<?> getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getTypeID() {
        return this.getType().getRegistryName();
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        curTooltip.add(PneumaticCraftUtils.xlate(this.getTranslationKey(), new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.DARK_AQUA, TextFormatting.UNDERLINE}));
        if (this.freeToUse()) {
            curTooltip.add((ITextComponent)new TranslationTextComponent("gui.progWidget.comment.tooltip.freeToUse", new Object[0]));
        }
    }

    public String getExtraStringInfo() {
        return null;
    }

    @Override
    public void addWarnings(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        if (this instanceof IVariableWidget) {
            HashSet<String> variables = new HashSet<String>();
            ((IVariableWidget)((Object)this)).addVariables(variables);
            for (String variable : variables) {
                if (variable.equals("") || variable.startsWith("#") || variable.startsWith("$") || this.isVariableSetAnywhere(widgets, variable)) continue;
                curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.general.warning.variableNeverSet", variable));
            }
        }
    }

    private boolean isVariableSetAnywhere(List<IProgWidget> widgets, String variable) {
        if (variable.equals("")) {
            return true;
        }
        for (IProgWidget widget : widgets) {
            if (!(widget instanceof IVariableSetWidget)) continue;
            HashSet<String> variables = new HashSet<String>();
            ((IVariableSetWidget)((Object)widget)).addVariables(variables);
            if (!variables.contains(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        if (!this.hasStepInput() && this.hasStepOutput() && this.outputStepConnection == null) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.general.error.noPieceConnected", new Object[0]));
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return 30;
    }

    @Override
    public int getHeight() {
        return !this.getParameters().isEmpty() ? this.getParameters().size() * 22 : 22;
    }

    @Override
    public void setParent(IProgWidget widget) {
        this.parent = widget;
    }

    @Override
    public IProgWidget getParent() {
        return this.parent;
    }

    @Override
    public void render() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
        int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
        Pair<Double, Double> maxUV = this.getMaxUV();
        double u = (Double)maxUV.getLeft();
        double v = (Double)maxUV.getRight();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_187315_a(0.0, v).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_187315_a(u, v).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_187315_a(u, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void renderExtraInfo() {
        if (this.getExtraStringInfo() != null) {
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            List<String> splittedInfo = PneumaticCraftUtils.splitString(this.getExtraStringInfo(), 20);
            for (int i = 0; i < splittedInfo.size(); ++i) {
                int stringLength = fr.func_78256_a(splittedInfo.get(i));
                int startX = this.getWidth() / 2 - stringLength / 4;
                int n = this.getHeight() / 2;
                fr.getClass();
                int n2 = n - (9 + 1) * (splittedInfo.size() - 1) / 4;
                fr.getClass();
                int n3 = n2 + (9 + 1) * i / 2;
                fr.getClass();
                int startY = n3 - 9 / 4;
                fr.getClass();
                AbstractGui.fill((int)(startX * 2 - 1), (int)(startY * 2 - 1), (int)(startX * 2 + stringLength + 1), (int)(startY * 2 + 9 + 1), (int)-1);
                fr.func_211126_b(splittedInfo.get(i), (float)(startX * 2), (float)(startY * 2), -16777216);
            }
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public Pair<Double, Double> getMaxUV() {
        int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
        int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
        int textureSize = this.getTextureSize();
        double u = (double)width / (double)textureSize;
        double v = (double)height / (double)textureSize;
        return new ImmutablePair((Object)u, (Object)v);
    }

    @Override
    public int getTextureSize() {
        int textureSize;
        int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
        int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
        int maxSize = Math.max(width, height);
        for (textureSize = 1; textureSize < maxSize; textureSize *= 2) {
        }
        return textureSize;
    }

    @Override
    public boolean hasStepOutput() {
        return this.hasStepInput();
    }

    @Override
    public Goal getWidgetTargetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public void setParameter(int index, IProgWidget parm) {
        int index2;
        int n = index2 = index >= this.getParameters().size() ? index - this.getParameters().size() : index;
        if (this.connectedParameters != null && (parm == null || parm.getType() == this.getParameters().get(index2))) {
            this.connectedParameters[index] = parm;
        }
    }

    @Override
    public boolean canSetParameter(int index) {
        if (this.connectedParameters != null) {
            return this.hasBlacklist() || index < this.connectedParameters.length / 2;
        }
        return false;
    }

    protected boolean hasBlacklist() {
        return true;
    }

    @Override
    public IProgWidget[] getConnectedParameters() {
        return this.connectedParameters;
    }

    @Override
    public void setOutputWidget(IProgWidget widget) {
        this.outputStepConnection = widget;
    }

    @Override
    public IProgWidget getOutputWidget() {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget copy() {
        IProgWidget copy = IProgWidget.create(this.getType());
        CompoundNBT tag = new CompoundNBT();
        this.writeToNBT(tag);
        copy.readFromNBT(tag);
        return copy;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        tag.func_74778_a("name", this.getTypeID().toString());
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        buf.func_192572_a(this.getTypeID());
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.y);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        this.x = buf.func_150792_a();
        this.y = buf.func_150792_a();
    }

    static <T extends IProgWidget> List<T> getConnectedWidgetList(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        ProgWidget.validateType(widget, parameterIndex, type);
        IProgWidget connectingWidget = widget.getConnectedParameters()[parameterIndex];
        if (connectingWidget != null) {
            ArrayList<T> list = new ArrayList<T>();
            while (connectingWidget != null) {
                list.add(type.cast(connectingWidget));
                connectingWidget = connectingWidget.getConnectedParameters()[0];
            }
            return list;
        }
        return null;
    }

    private static <T extends IProgWidget> void validateType(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        int l = widget.getParameters().size();
        if (parameterIndex >= l) {
            parameterIndex -= l;
        }
        if (type != widget.getParameters().get(parameterIndex)) {
            throw new IllegalArgumentException(String.format("invalid type %s for parameter %d (expected %s)", new Object[]{type, parameterIndex, widget.getParameters().get(parameterIndex)}));
        }
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return this.getWidgetAI(drone, widget) != null;
    }
}

