/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class ProgWidgetDigAndPlace
extends ProgWidgetAreaItemBase
implements IBlockOrdered,
IMaxActions {
    private IBlockOrdered.EnumOrder order;
    private int maxActions = 1;
    private boolean useMaxActions;

    @Override
    public IBlockOrdered.EnumOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IBlockOrdered.EnumOrder order) {
        this.order = order;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((ITextComponent)new StringTextComponent("Order: " + this.order.getLocalizedName()));
    }

    ProgWidgetDigAndPlace(ProgWidgetType type, IBlockOrdered.EnumOrder order) {
        super(type);
        this.order = order;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("order", this.order.ordinal());
        tag.func_74757_a("useMaxActions", this.useMaxActions);
        tag.func_74768_a("maxActions", this.maxActions);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.order = IBlockOrdered.EnumOrder.values()[tag.func_74762_e("order")];
        this.useMaxActions = tag.func_74767_n("useMaxActions");
        this.maxActions = tag.func_74762_e("maxActions");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeByte(this.order.ordinal());
        buf.writeBoolean(this.useMaxActions);
        buf.func_150787_b(this.maxActions);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.order = IBlockOrdered.EnumOrder.values()[buf.readByte()];
        this.useMaxActions = buf.readBoolean();
        this.maxActions = buf.func_150792_a();
    }

    @Override
    public String getExtraStringInfo() {
        return this.order.getLocalizedName();
    }

    @Override
    public void setMaxActions(int maxActions) {
        this.maxActions = maxActions;
    }

    @Override
    public int getMaxActions() {
        return this.maxActions;
    }

    @Override
    public void setUseMaxActions(boolean useMaxActions) {
        this.useMaxActions = useMaxActions;
    }

    @Override
    public boolean useMaxActions() {
        return this.useMaxActions;
    }

    DroneAIBlockInteraction setupMaxActions(DroneAIBlockInteraction ai, IMaxActions widget) {
        return widget.useMaxActions() ? ai.setMaxActions(widget.getMaxActions()) : ai;
    }
}

