/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ProgWidgetEnergyCondition
extends ProgWidgetCondition {
    public ProgWidgetEnergyCondition() {
        super((ProgWidgetType)ModProgWidgets.CONDITION_RF.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ENERGY;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.AREA.get(), (Object)ModProgWidgets.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                TileEntity te = this.drone.world().func_175625_s(pos);
                if (te == null) {
                    return false;
                }
                int energy = 0;
                for (Direction face : Direction.field_199792_n) {
                    if (!ProgWidgetEnergyCondition.this.getSides()[face.func_176745_a()]) continue;
                    energy = Math.max(energy, this.getEnergy(te, face));
                }
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(energy, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }

            private int getEnergy(TileEntity te, Direction side) {
                return (Integer)te.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse((Object)0);
            }
        };
    }
}

