/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIAttackEntity;
import me.desht.pneumaticcraft.common.ai.DroneAINearestAttackableTarget;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ProgWidgetEntityAttack
extends ProgWidget
implements IAreaProvider,
IEntityProvider {
    private EntityFilterPair<ProgWidgetEntityAttack> entityFilters;

    public ProgWidgetEntityAttack() {
        super((ProgWidgetType)ModProgWidgets.ENTITY_ATTACK.get());
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.area.error.noArea", new Object[0]));
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIAttackEntity((EntityDrone)drone, 0.1, false);
    }

    @Override
    public Goal getWidgetTargetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAINearestAttackableTarget((EntityDrone)drone, false, (ProgWidget)widget);
    }

    @Override
    public ProgWidgetType returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.AREA.get(), (Object)ModProgWidgets.TEXT.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ATTACK;
    }

    @Override
    public List<Entity> getValidEntities(World world) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityAttack>(this);
        }
        return this.entityFilters.getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityAttack>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetEntityAttack.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[2]);
    }

    public static void getArea(Set<BlockPos> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            widget.getArea(area, new AreaTypeBox());
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            HashSet<BlockPos> blacklistedArea = new HashSet<BlockPos>();
            widget.getArea(blacklistedArea, new AreaTypeBox());
            area.removeAll(blacklistedArea);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }
}

