/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ProgWidgetItemFilter
extends ProgWidget
implements IVariableWidget {
    private ItemStack filter = ItemStack.field_190927_a;
    public boolean useItemDurability;
    public boolean useNBT;
    public boolean useModSimilarity;
    public boolean matchBlock;
    private DroneAIManager aiManager;
    private String variable = "";

    public ProgWidgetItemFilter() {
        super((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
    }

    public static ProgWidgetItemFilter withFilter(ItemStack filter) {
        ProgWidgetItemFilter widget = new ProgWidgetItemFilter();
        widget.filter = filter;
        return widget;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("") && this.filter == null) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.itemFilter.error.noFilter", new Object[0]));
        }
        if (this.matchBlock && !(this.filter.func_77973_b() instanceof BlockItem)) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.itemFilter.error.notBlock", new Object[0]));
        }
    }

    @Override
    public void renderExtraInfo() {
        if (this.variable.equals("")) {
            if (!this.filter.func_190926_b()) {
                GuiUtils.drawItemStack(this.filter, 10, 2, "");
            }
        } else {
            super.renderExtraInfo();
        }
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.variable + "\"";
    }

    @Nonnull
    public ItemStack getFilter() {
        return this.variable.equals("") ? this.filter : (this.aiManager != null ? this.aiManager.getStack(this.variable) : ItemStack.field_190927_a);
    }

    public ItemStack getRawFilter() {
        return this.filter;
    }

    public void setFilter(@Nonnull ItemStack filter) {
        this.filter = filter.func_77946_l();
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.filter.func_190926_b()) {
            curTooltip.add(new StringTextComponent("Filter: ").func_211708_a(TextFormatting.AQUA).func_150257_a(this.filter.func_200301_q()));
            if (this.useModSimilarity) {
                curTooltip.add(new StringTextComponent("- Using Mod Similarity").func_211708_a(TextFormatting.DARK_AQUA));
            } else {
                curTooltip.add(new StringTextComponent((this.useItemDurability ? "Using" : "Ignoring") + " item damage").func_211708_a(TextFormatting.DARK_AQUA));
                if (this.matchBlock) {
                    curTooltip.add(new StringTextComponent("- Matching by block").func_211708_a(TextFormatting.DARK_AQUA));
                } else {
                    curTooltip.add(new StringTextComponent(this.useNBT ? "Using NBT" : "Ignoring NBT").func_211708_a(TextFormatting.DARK_AQUA));
                }
            }
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType returnType() {
        return (ProgWidgetType)ModProgWidgets.ITEM_FILTER.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.ITEM_FILTER.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_FILTER;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (!this.filter.func_190926_b()) {
            this.filter.func_77955_b(tag);
        }
        tag.func_74757_a("useMetadata", this.useItemDurability);
        tag.func_74757_a("useNBT", this.useNBT);
        tag.func_74757_a("useModSimilarity", this.useModSimilarity);
        tag.func_74757_a("matchBlock", this.matchBlock);
        tag.func_74778_a("variable", this.variable);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.filter = ItemStack.func_199557_a((CompoundNBT)tag);
        this.useItemDurability = tag.func_74767_n("useMetadata");
        this.useNBT = tag.func_74767_n("useNBT");
        this.useModSimilarity = tag.func_74767_n("useModSimilarity");
        this.matchBlock = tag.func_74767_n("matchBlock");
        this.variable = tag.func_74779_i("variable");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.func_150788_a(this.filter);
        buf.writeBoolean(this.useItemDurability);
        buf.writeBoolean(this.useNBT);
        buf.writeBoolean(this.useModSimilarity);
        buf.writeBoolean(this.matchBlock);
        buf.func_180714_a(this.variable);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.filter = buf.func_150791_c();
        this.useItemDurability = buf.readBoolean();
        this.useNBT = buf.readBoolean();
        this.useModSimilarity = buf.readBoolean();
        this.matchBlock = buf.readBoolean();
        this.variable = buf.func_150789_c(64);
    }

    public static boolean isItemValidForFilters(ItemStack item, List<ProgWidgetItemFilter> whitelist, List<ProgWidgetItemFilter> blacklist, BlockState blockState) {
        if (blacklist != null) {
            for (ProgWidgetItemFilter black : blacklist) {
                if (!ProgWidgetItemFilter.matchFilter(item, blockState, black)) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetItemFilter white : whitelist) {
            if (!ProgWidgetItemFilter.matchFilter(item, blockState, white)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFilter(ItemStack stack, BlockState blockState, ProgWidgetItemFilter filter) {
        if (filter.matchBlock && stack.func_190926_b() && blockState != null && filter.getFilter().func_77973_b() instanceof BlockItem) {
            return blockState.func_177230_c() == ((BlockItem)filter.getFilter().func_77973_b()).func_179223_d();
        }
        if (PneumaticCraftUtils.doesItemMatchFilter(filter.getFilter(), stack, filter.useItemDurability && blockState == null, filter.useNBT, filter.useModSimilarity)) {
            return blockState == null || !filter.useItemDurability;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

