/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class ProgWidgetItemInventoryCondition
extends ProgWidgetCondition {
    public ProgWidgetItemInventoryCondition() {
        super((ProgWidgetType)ModProgWidgets.CONDITION_ITEM_INVENTORY.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.AREA.get(), (Object)ModProgWidgets.ITEM_FILTER.get(), (Object)ModProgWidgets.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                TileEntity te = this.drone.world().func_175625_s(pos);
                boolean[] sides = ((ISidedWidget)((Object)this.progWidget)).getSides();
                HashSet handlers = new HashSet();
                for (int sideIdx = 0; sideIdx < sides.length; ++sideIdx) {
                    if (!sides[sideIdx]) continue;
                    IOHelper.getInventoryForTE(te, Direction.func_82600_a((int)sideIdx)).ifPresent(handlers::add);
                }
                int count = 0;
                for (IItemHandler handler : handlers) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (!this.progWidget.isItemValidForFilters(stack)) continue;
                        count += stack.func_190916_E();
                    }
                }
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(count, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ITEM_INVENTORY;
    }
}

