/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ProgWidgetJump
extends ProgWidget
implements IJump {
    public ProgWidgetJump() {
        super((ProgWidgetType)ModProgWidgets.JUMP.get());
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.label.error.noJumpLocation", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public boolean hasStepOutput() {
        return false;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        ProgWidgetText jumpedLabel = (ProgWidgetText)this.getConnectedParameters()[0];
        if (jumpedLabel != null) {
            drone.getAIManager().setLabel(jumpedLabel.string);
            IProgWidget widget = ProgWidgetJump.jumpToLabel(drone, allWidgets, jumpedLabel.string);
            if (widget != null) {
                return widget;
            }
        }
        drone.addDebugEntry("gui.progWidget.jump.nowhereToJump");
        return null;
    }

    static IProgWidget jumpToLabel(IDroneBase drone, List<IProgWidget> allWidgets, IProgWidget conditionWidget, boolean conditionValue) {
        ProgWidgetText textWidget = (ProgWidgetText)(conditionValue ? conditionWidget.getConnectedParameters()[conditionWidget.getParameters().size() - 1] : conditionWidget.getConnectedParameters()[conditionWidget.getParameters().size() * 2 - 1]);
        if (textWidget != null) {
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, textWidget.string);
        }
        IProgWidget widget = conditionWidget.getOutputWidget();
        if (widget == null) {
            drone.addDebugEntry("gui.progWidget.jump.nowhereToJump");
        }
        return widget;
    }

    static IProgWidget jumpToLabel(IDroneBase drone, List<IProgWidget> allWidgets, String label) {
        drone.getAIManager().setLabel(label);
        ArrayList<IProgWidget> possibleJumpLocations = new ArrayList<IProgWidget>();
        for (IProgWidget widget : allWidgets) {
            String labelLabel;
            if (!(widget instanceof ILabel) || (labelLabel = ((ILabel)((Object)widget)).getLabel()) == null || !labelLabel.equals(label)) continue;
            possibleJumpLocations.add(widget);
        }
        if (possibleJumpLocations.size() == 0) {
            drone.addDebugEntry("gui.progWidget.jump.nowhereToJump");
            return null;
        }
        return (IProgWidget)possibleJumpLocations.get(new Random().nextInt(possibleJumpLocations.size()));
    }

    @Override
    public IProgWidget getOutputWidget() {
        return null;
    }

    @Override
    public ProgWidgetType returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.TEXT.get());
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_JUMP;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        ProgWidgetText jumpedLabel = (ProgWidgetText)this.getConnectedParameters()[0];
        if (jumpedLabel != null) {
            return Collections.singletonList(jumpedLabel.string);
        }
        return Collections.emptyList();
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.WHITE;
    }
}

