/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.IModRecipeSerializer;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.RegisterMachineRecipesEvent;
import me.desht.pneumaticcraft.api.crafting.StackedIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.IModRecipe;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.network.PacketSyncRecipes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.machine.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.BasicPressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.BasicThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberDisenchantingRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberEnchantingRecipe;
import me.desht.pneumaticcraft.common.recipes.machine.RefineryRecipe;
import me.desht.pneumaticcraft.common.util.DatapackHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MachineRecipeHandler {
    private static final String MACHINE_RECIPES = "pneumaticcraft/machine_recipes/";

    private static PacketSyncRecipes syncPacket() {
        return new PacketSyncRecipes(PneumaticCraftRecipes.pressureChamberRecipes, PneumaticCraftRecipes.thermopneumaticProcessingPlantRecipes, PneumaticCraftRecipes.heatFrameCoolingRecipes, PneumaticCraftRecipes.explosionCraftingRecipes, PneumaticCraftRecipes.refineryRecipes, PneumaticCraftRecipes.assemblyLaserRecipes, PneumaticCraftRecipes.assemblyDrillRecipes, PneumaticCraftRecipes.assemblyLaserDrillRecipes);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationEvents {
        @SubscribeEvent
        public static void onRegister(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            CraftingHelper.register((ResourceLocation)StackedIngredient.Serializer.ID, (IIngredientSerializer)StackedIngredient.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)FluidIngredient.Serializer.ID, (IIngredientSerializer)FluidIngredient.Serializer.INSTANCE);
            ModCraftingHelper.register(Category.ASSEMBLY.getId(), AssemblyRecipe.Serializer::new);
            ModCraftingHelper.register(Category.PRESSURE_CHAMBER.getId(), BasicPressureChamberRecipe.Serializer::new);
            ModCraftingHelper.register(Category.THERMO_PLANT.getId(), BasicThermopneumaticProcessingPlantRecipe.Serializer::new);
            ModCraftingHelper.register(Category.EXPLOSION_CRAFTING.getId(), ExplosionCraftingRecipe.Serializer::new);
            ModCraftingHelper.register(Category.HEAT_FRAME_COOLING.getId(), HeatFrameCoolingRecipe.Serializer::new);
            ModCraftingHelper.register(Category.REFINERY.getId(), RefineryRecipe.Serializer::new);
            ModCraftingHelper.register(PressureChamberEnchantingRecipe.ID, PressureChamberEnchantingRecipe.Serializer::new);
            ModCraftingHelper.register(PressureChamberDisenchantingRecipe.ID, PressureChamberDisenchantingRecipe.Serializer::new);
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class CommonEvents {
        @SubscribeEvent
        public static void serverLogin(PlayerEvent.PlayerLoggedInEvent evt) {
            NetworkHandler.sendNonLocal((ServerPlayerEntity)evt.getPlayer(), MachineRecipeHandler.syncPacket());
            NetworkHandler.sendNonLocal((ServerPlayerEntity)evt.getPlayer(), new PacketSyncAmadronOffers());
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void clientLogout(ClientPlayerNetworkEvent.LoggedOutEvent evt) {
            PneumaticCraftRecipes.pressureChamberRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.thermopneumaticProcessingPlantRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.heatFrameCoolingRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.explosionCraftingRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.refineryRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.assemblyLaserRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.assemblyDrillRecipes = Collections.emptyMap();
            PneumaticCraftRecipes.assemblyLaserDrillRecipes = Collections.emptyMap();
        }
    }

    public static class ReloadListener
    implements IResourceManagerReloadListener {
        private List<Map<ResourceLocation, JsonObject>> allRecipes = new ArrayList<Map<ResourceLocation, JsonObject>>();

        public void func_195410_a(IResourceManager resourceManager) {
            this.allRecipes.clear();
            for (Category cat : Category.values()) {
                this.allRecipes.add(this.loadJSON(resourceManager, cat));
            }
            Map pressureChamber = this.parseJSON(Category.PRESSURE_CHAMBER);
            Map thermopneumatic = this.parseJSON(Category.THERMO_PLANT);
            Map heatFrameCooling = this.parseJSON(Category.HEAT_FRAME_COOLING);
            Map explosionCrafting = this.parseJSON(Category.EXPLOSION_CRAFTING);
            Map refinery = this.parseJSON(Category.REFINERY);
            Map assembly = this.parseJSON(Category.ASSEMBLY);
            RegisterMachineRecipesEvent.Pre evt = new RegisterMachineRecipesEvent.Pre(r -> pressureChamber.put(r.getId(), r), r -> thermopneumatic.put(r.getId(), r), r -> heatFrameCooling.put(r.getId(), r), r -> explosionCrafting.put(r.getId(), r), r -> refinery.put(r.getId(), r), r -> assembly.put(r.getId(), r));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            PneumaticCraftRecipes.pressureChamberRecipes = ImmutableMap.copyOf(pressureChamber);
            PneumaticCraftRecipes.thermopneumaticProcessingPlantRecipes = ImmutableMap.copyOf(thermopneumatic);
            PneumaticCraftRecipes.heatFrameCoolingRecipes = ImmutableMap.copyOf(heatFrameCooling);
            PneumaticCraftRecipes.explosionCraftingRecipes = ImmutableMap.copyOf(explosionCrafting);
            PneumaticCraftRecipes.refineryRecipes = ImmutableMap.copyOf(refinery);
            AssemblyRecipe.setupRecipeSubtypes(assembly.values());
            AmadronOfferManager.getInstance().initOffers(resourceManager);
            NetworkHandler.sendToAll(MachineRecipeHandler.syncPacket());
            MinecraftForge.EVENT_BUS.post((Event)new RegisterMachineRecipesEvent.Post());
        }

        private Map<ResourceLocation, JsonObject> loadJSON(IResourceManager resourceManager, Category category) {
            return DatapackHelper.loadJSONFiles(resourceManager, MachineRecipeHandler.MACHINE_RECIPES + category.getName(), category.getName() + " recipe");
        }

        private <T extends IModRecipe> Map<ResourceLocation, T> parseJSON(Category category) {
            HashMap result = new HashMap();
            this.allRecipes.get(category.ordinal()).forEach((recipeId, json) -> {
                try {
                    ResourceLocation type = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)("pneumaticcraft:" + category.getName())));
                    IModRecipeSerializer<ResourceLocation> serializer = ModCraftingHelper.getSerializer(type);
                    if (serializer != null) {
                        ResourceLocation recipe = serializer.read((ResourceLocation)recipeId, (JsonObject)json);
                        if (recipe != null) {
                            result.put(recipeId, recipe);
                        }
                    } else {
                        Log.error("can't deserialize recipe %s - no deserializer for %s", recipeId, type);
                    }
                }
                catch (JsonParseException e) {
                    Log.error("can't deserialize %s recipe %s (%s) - stack trace follows:", category.getName(), recipeId, e.getMessage());
                    Log.error(ExceptionUtils.getStackTrace((Throwable)e), new Object[0]);
                }
            });
            return result;
        }
    }

    public static enum Category {
        PRESSURE_CHAMBER("pressure_chamber"),
        THERMO_PLANT("thermopneumatic_processing_plant"),
        HEAT_FRAME_COOLING("heat_frame_cooling"),
        REFINERY("refinery"),
        EXPLOSION_CRAFTING("explosion_crafting"),
        ASSEMBLY("assembly");

        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getId() {
            return PneumaticCraftUtils.RL(this.name);
        }
    }
}

