/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.crafting.IModRecipeSerializer;
import me.desht.pneumaticcraft.api.crafting.recipe.IModRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ModCraftingHelper {
    private static final Supplier<IModRecipeSerializer<?>> MISSING = () -> null;
    private static final Map<ResourceLocation, Supplier<IModRecipeSerializer<? extends IModRecipe>>> factories = new HashMap<ResourceLocation, Supplier<IModRecipeSerializer<? extends IModRecipe>>>();

    static void register(ResourceLocation recipeType, Supplier<IModRecipeSerializer<? extends IModRecipe>> deserializer) {
        factories.put(recipeType, deserializer);
    }

    public static <T extends IModRecipe> IModRecipeSerializer<T> getSerializer(ResourceLocation type) {
        return factories.getOrDefault(type, MISSING).get();
    }

    public static <T extends IModRecipe> IModRecipeSerializer<T> getSerializer(T recipe) {
        return factories.getOrDefault(recipe.getRecipeType(), MISSING).get();
    }

    public static void writeRecipe(IModRecipe recipe, PacketBuffer buf) {
        ModCraftingHelper.getSerializer(recipe).write(buf, recipe);
    }

    public static <T extends IModRecipe> T readRecipe(PacketBuffer buf) {
        return (T)ModCraftingHelper.getSerializer(buf.func_192575_l()).read(buf.func_192575_l(), buf);
    }

    public static FluidStack fluidStackFromJSON(JsonObject json) {
        String fluidName = JSONUtils.func_151200_h((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.field_204541_a) {
            throw new JsonSyntaxException("unknown fluid: " + fluidName);
        }
        int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
        return new FluidStack(fluid, amount);
    }
}

