/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class AmadronOffer {
    private final ResourceLocation offerId;
    protected final AmadronTradeResource input;
    protected final AmadronTradeResource output;

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output) {
        this.offerId = id;
        this.input = input.validate();
        this.output = output.validate();
    }

    public ResourceLocation getOfferId() {
        return this.offerId;
    }

    public AmadronTradeResource getInput() {
        return this.input;
    }

    public AmadronTradeResource getOutput() {
        return this.output;
    }

    public boolean equivalentTo(AmadronPlayerOffer offer) {
        return this.input.equivalentTo(offer.getInput()) && this.output.equivalentTo(offer.getOutput());
    }

    public String getVendor() {
        return PneumaticCraftUtils.xlate("gui.amadron", new Object[0]).func_150254_d();
    }

    public int getStock() {
        return -1;
    }

    public boolean passesQuery(String query) {
        String queryLow = query.toLowerCase();
        return this.getInput().getName().toLowerCase().contains(queryLow) || this.getOutput().getName().toLowerCase().contains(queryLow) || this.getVendor().toLowerCase().contains(queryLow);
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74778_a("id", this.offerId.toString());
        tag.func_218657_a("input", (INBT)this.input.writeToNBT());
        tag.func_218657_a("output", (INBT)this.output.writeToNBT());
    }

    public static AmadronOffer loadFromNBT(CompoundNBT tag) {
        return new AmadronOffer(new ResourceLocation(tag.func_74779_i("id")), AmadronTradeResource.fromNBT(tag.func_74775_l("input")), AmadronTradeResource.fromNBT(tag.func_74775_l("output")));
    }

    public void writeToBuf(PacketBuffer buf) {
        buf.func_192572_a(this.offerId);
        this.input.writeToBuf(buf);
        this.output.writeToBuf(buf);
    }

    public static AmadronOffer readFromBuf(PacketBuffer buf) {
        return new AmadronOffer(buf.func_192575_l(), AmadronTradeResource.fromPacketBuf(buf), AmadronTradeResource.fromPacketBuf(buf));
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("id", this.offerId.toString());
        object.add("input", (JsonElement)this.input.toJson());
        object.add("output", (JsonElement)this.output.toJson());
        return object;
    }

    public static AmadronOffer fromJson(JsonObject object) throws CommandSyntaxException {
        return new AmadronOffer(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"id")), AmadronTradeResource.fromJson(object.getAsJsonObject("input")), AmadronTradeResource.fromJson(object.getAsJsonObject("output")));
    }

    public String toString() {
        return String.format("[id = %s, in = %s, out = %s]", this.offerId.toString(), this.input.toString(), this.output.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronOffer)) {
            return false;
        }
        AmadronOffer that = (AmadronOffer)o;
        return this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }
}

