/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.ArrayList;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.util.GlobalPosUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class AmadronPlayerOffer
extends AmadronOffer {
    private final String offeringPlayerName;
    private String offeringPlayerId;
    private GlobalPos providingPos;
    private GlobalPos returningPos;
    private int inStock;
    private int pendingPayments;
    private TileEntity cachedInput;
    private TileEntity cachedOutput;

    public AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, PlayerEntity offeringPlayer) {
        this(id, input, output, offeringPlayer.func_146103_bH().getName(), offeringPlayer.func_146103_bH().getId().toString());
    }

    public AmadronPlayerOffer(ResourceLocation id, AmadronTradeResource input, AmadronTradeResource output, String playerName, String playerId) {
        super(id, input, output);
        this.offeringPlayerName = playerName;
        this.offeringPlayerId = playerId;
    }

    public AmadronPlayerOffer setProvidingPosition(GlobalPos pos) {
        this.providingPos = pos;
        this.cachedInput = null;
        return this;
    }

    public AmadronPlayerOffer setReturningPosition(GlobalPos pos) {
        this.returningPos = pos;
        this.cachedOutput = null;
        return this;
    }

    public AmadronPlayerOffer getReversedOffer() {
        ResourceLocation reversedId = AmadronPlayerOffer.getReversedId(this.getOfferId());
        AmadronPlayerOffer reversed = new AmadronPlayerOffer(reversedId, this.getOutput(), this.getInput(), this.offeringPlayerName, this.offeringPlayerId);
        reversed.providingPos = this.providingPos;
        reversed.returningPos = this.returningPos;
        reversed.inStock = this.inStock;
        reversed.pendingPayments = this.pendingPayments;
        return reversed;
    }

    public AmadronPlayerOffer copy() {
        CompoundNBT tag = new CompoundNBT();
        this.writeToNBT(tag);
        return AmadronPlayerOffer.loadFromNBT(tag);
    }

    public void updatePlayerId() {
        PlayerEntity player = PneumaticCraftUtils.getPlayerFromName(this.offeringPlayerName);
        if (player != null) {
            this.offeringPlayerId = player.func_146103_bH().getId().toString();
        }
    }

    public void addStock(int stock) {
        this.inStock += stock;
        if (this.inStock < 0) {
            Log.warning("in-stock for " + this + " dropped to " + this.inStock + "? shouldn't happen!", new Object[0]);
            this.inStock = 0;
        }
    }

    @Override
    public int getStock() {
        return this.inStock;
    }

    public void addPayment(int payment) {
        this.pendingPayments += payment;
    }

    @Override
    public String getVendor() {
        return this.offeringPlayerName;
    }

    public String getPlayerId() {
        return this.offeringPlayerId;
    }

    @Override
    public void onTrade(int tradingAmount, String buyingPlayer) {
        PlayerEntity player = PneumaticCraftUtils.getPlayerFromId(this.offeringPlayerId);
        if (player != null && PNCConfig.Common.Amadron.notifyOfDealMade) {
            NetworkHandler.sendToPlayer(new PacketAmadronTradeNotifyDeal(this, tradingAmount, buyingPlayer), (ServerPlayerEntity)player);
        }
    }

    boolean payout() {
        boolean madePayment = false;
        TileEntity returning = this.getReturningTileEntity();
        if (this.pendingPayments > 0) {
            int paying = Math.min(this.pendingPayments, 50);
            switch (this.getInput().getType()) {
                case ITEM: {
                    paying = this.getInput().findSpaceInItemOutput(IOHelper.getInventoryForTE(returning), paying);
                    break;
                }
                case FLUID: {
                    paying = this.getInput().findSpaceInFluidOutput(IOHelper.getFluidHandlerForTE(returning), paying);
                }
            }
            if (paying > 0) {
                this.pendingPayments -= paying;
                madePayment = true;
                switch (this.getInput().getType()) {
                    case ITEM: {
                        ItemStack stack;
                        ItemStack deliveringItems = this.getInput().getItem();
                        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                        for (int amount = deliveringItems.func_190916_E() * paying; amount > 0; amount -= stack.func_190916_E()) {
                            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)deliveringItems, (int)Math.min(amount, deliveringItems.func_77976_d()));
                            stacks.add(stack);
                        }
                        DroneRegistry.getInstance().deliverItemsAmazonStyle(this.returningPos, stacks.toArray(new ItemStack[0]));
                        break;
                    }
                    case FLUID: {
                        FluidStack deliveringFluid = this.getInput().getFluid().copy();
                        deliveringFluid.setAmount(deliveringFluid.getAmount() * paying);
                        DroneRegistry.getInstance().deliverFluidAmazonStyle(this.returningPos, deliveringFluid);
                    }
                }
            }
        }
        return madePayment;
    }

    public void returnStock() {
        while (this.inStock > 0) {
            int stock = Math.min(this.inStock, 64);
            this.inStock -= stock;
            switch (this.getOutput().getType()) {
                case ITEM: {
                    ItemStack stack;
                    ItemStack deliveringItems = this.getOutput().getItem();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int amount = deliveringItems.func_190916_E() * stock; amount > 0; amount -= stack.func_190916_E()) {
                        stack = ItemHandlerHelper.copyStackWithSize((ItemStack)deliveringItems, (int)Math.min(amount, deliveringItems.func_77976_d()));
                        stacks.add(stack);
                    }
                    DroneRegistry.getInstance().deliverItemsAmazonStyle(this.providingPos, stacks.toArray(new ItemStack[0]));
                    break;
                }
                case FLUID: {
                    FluidStack deliveringFluid = this.getOutput().getFluid().copy();
                    deliveringFluid.setAmount(deliveringFluid.getAmount() * stock);
                    DroneRegistry.getInstance().deliverFluidAmazonStyle(this.providingPos, deliveringFluid);
                }
            }
        }
    }

    TileEntity getProvidingTileEntity() {
        if ((this.cachedInput == null || this.cachedInput.func_145837_r()) && this.providingPos != null) {
            this.cachedInput = GlobalPosUtils.getTileEntity(this.providingPos);
        }
        return this.cachedInput;
    }

    TileEntity getReturningTileEntity() {
        if ((this.cachedOutput == null || this.cachedOutput.func_145837_r()) && this.returningPos != null) {
            this.cachedOutput = GlobalPosUtils.getTileEntity(this.returningPos);
        }
        return this.cachedOutput;
    }

    GlobalPos getProvidingPos() {
        return this.providingPos;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("offeringPlayerId", this.offeringPlayerId);
        tag.func_74778_a("offeringPlayerName", this.offeringPlayerName);
        tag.func_74768_a("inStock", this.inStock);
        tag.func_74768_a("pendingPayments", this.pendingPayments);
        if (this.providingPos != null) {
            tag.func_218657_a("providingPos", (INBT)GlobalPosUtils.serializeGlobalPos(this.providingPos));
        }
        if (this.returningPos != null) {
            tag.func_218657_a("returningPos", (INBT)GlobalPosUtils.serializeGlobalPos(this.returningPos));
        }
    }

    public static AmadronPlayerOffer loadFromNBT(CompoundNBT tag) {
        AmadronOffer offer = AmadronOffer.loadFromNBT(tag);
        AmadronPlayerOffer custom = new AmadronPlayerOffer(offer.getOfferId(), offer.getInput(), offer.getOutput(), tag.func_74779_i("offeringPlayerName"), tag.func_74779_i("offeringPlayerId"));
        custom.inStock = tag.func_74762_e("inStock");
        custom.pendingPayments = tag.func_74762_e("pendingPayments");
        if (tag.func_74764_b("providingPos")) {
            custom.setProvidingPosition(GlobalPosUtils.deserializeGlobalPos(tag.func_74775_l("providingPos")));
        }
        if (tag.func_74764_b("returningPos")) {
            custom.setProvidingPosition(GlobalPosUtils.deserializeGlobalPos(tag.func_74775_l("returningPos")));
        }
        return custom;
    }

    @Override
    public void writeToBuf(PacketBuffer buf) {
        super.writeToBuf(buf);
        buf.func_180714_a(this.offeringPlayerName);
        buf.func_180714_a(this.offeringPlayerId);
        buf.writeBoolean(this.providingPos != null);
        if (this.providingPos != null) {
            PacketUtil.writeGlobalPos(buf, this.providingPos);
        }
        buf.writeBoolean(this.returningPos != null);
        if (this.returningPos != null) {
            PacketUtil.writeGlobalPos(buf, this.returningPos);
        }
        buf.func_150787_b(this.inStock);
        buf.func_150787_b(this.pendingPayments);
    }

    public static AmadronPlayerOffer loadFromBuf(PacketBuffer buf) {
        AmadronPlayerOffer offer = new AmadronPlayerOffer(buf.func_192575_l(), AmadronTradeResource.fromPacketBuf(buf), AmadronTradeResource.fromPacketBuf(buf), buf.func_150789_c(100), buf.func_150789_c(100));
        if (buf.readBoolean()) {
            offer.setProvidingPosition(PacketUtil.readGlobalPos(buf));
        }
        if (buf.readBoolean()) {
            offer.setReturningPosition(PacketUtil.readGlobalPos(buf));
        }
        offer.inStock = buf.func_150792_a();
        offer.pendingPayments = buf.func_150792_a();
        return offer;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("offeringPlayerName", this.offeringPlayerName);
        json.addProperty("offeringPlayerId", this.offeringPlayerId);
        json.addProperty("inStock", (Number)this.inStock);
        json.addProperty("pendingPayments", (Number)this.pendingPayments);
        if (this.providingPos != null) {
            json.add("providingPos", (JsonElement)this.providingPos.func_218175_a((DynamicOps)JsonOps.INSTANCE));
        }
        if (this.returningPos != null) {
            json.add("returningPos", (JsonElement)this.returningPos.func_218175_a((DynamicOps)JsonOps.INSTANCE));
        }
        return json;
    }

    public static AmadronPlayerOffer fromJson(JsonObject json) throws CommandSyntaxException {
        AmadronOffer offer = AmadronOffer.fromJson(json);
        AmadronPlayerOffer custom = new AmadronPlayerOffer(offer.getOfferId(), offer.input, offer.output, json.get("offeringPlayerName").getAsString(), json.get("offeringPlayerId").getAsString());
        custom.inStock = json.get("inStock").getAsInt();
        custom.pendingPayments = json.get("pendingPayments").getAsInt();
        if (json.has("providingPos")) {
            custom.providingPos = GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.get("providingPos")));
        }
        if (json.has("returningPos")) {
            custom.returningPos = GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.get("returningPos")));
        }
        return custom;
    }

    @Override
    public boolean equivalentTo(AmadronPlayerOffer otherOffer) {
        return super.equivalentTo(otherOffer) && this.offeringPlayerId.equals(otherOffer.offeringPlayerId);
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.offeringPlayerName;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AmadronPlayerOffer) {
            AmadronPlayerOffer offer = (AmadronPlayerOffer)o;
            return super.equals(o) && offer.offeringPlayerId.equals(this.offeringPlayerId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.offeringPlayerId.hashCode();
    }

    public static ResourceLocation getReversedId(ResourceLocation id) {
        String s = id.toString();
        return s.endsWith("_rev") ? new ResourceLocation(s.replaceFirst("_rev$", "")) : new ResourceLocation(s + "_rev");
    }
}

