/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.RegistryObject;

public abstract class AssemblyProgram {
    public EnumAssemblyProblem curProblem = EnumAssemblyProblem.NO_PROBLEM;

    public IAssemblyRecipe.AssemblyProgramType getType() {
        return this.getItem().getProgramType();
    }

    public abstract EnumMachine[] getRequiredMachines();

    public abstract boolean executeStep(TileEntityAssemblyController.AssemblySystem var1);

    public abstract void writeToNBT(CompoundNBT var1);

    public abstract void readFromNBT(CompoundNBT var1);

    public abstract Collection<IAssemblyRecipe> getRecipeList();

    public void addProgramProblem(List<String> problemList) {
        switch (this.curProblem) {
            case NO_INPUT: {
                problemList.addAll(PneumaticCraftUtils.splitString(TextFormatting.GRAY + "The input IO Unit can't find an inventory with a Block of Compressed Iron.", 26));
                problemList.addAll(PneumaticCraftUtils.splitString(TextFormatting.BLACK + "Place an inventory with a Block of Compressed Iron surrounding the IO Unit.", 26));
                break;
            }
            case NO_OUTPUT: {
                problemList.addAll(PneumaticCraftUtils.splitString(TextFormatting.GRAY + "The output IO Unit can't find an inventory to place the output in.", 26));
                problemList.addAll(PneumaticCraftUtils.splitString(TextFormatting.BLACK + "Place an inventory / make space in a connected inventory.", 26));
            }
        }
    }

    static boolean isValidInput(IAssemblyRecipe recipe, ItemStack input) {
        return recipe.matches(input);
    }

    public static AssemblyProgram fromRecipe(IAssemblyRecipe recipe) {
        return ItemAssemblyProgram.fromProgramType(recipe.getProgramType()).getProgram();
    }

    public abstract ItemAssemblyProgram getItem();

    public static enum EnumMachine {
        PLATFORM(ModBlocks.ASSEMBLY_PLATFORM),
        DRILL(ModBlocks.ASSEMBLY_DRILL),
        LASER(ModBlocks.ASSEMBLY_LASER),
        IO_UNIT_EXPORT(ModBlocks.ASSEMBLY_IO_UNIT_EXPORT),
        IO_UNIT_IMPORT(ModBlocks.ASSEMBLY_IO_UNIT_IMPORT),
        CONTROLLER(ModBlocks.ASSEMBLY_CONTROLLER);

        private final RegistryObject<? extends Block> blockSupplier;

        private EnumMachine(RegistryObject<? extends Block> blockSupplier) {
            this.blockSupplier = blockSupplier;
        }

        public String getTranslationKey() {
            return "block.pneumaticcraft.assembly_" + this.toString().toLowerCase();
        }

        public Block getMachineBlock() {
            return (Block)this.blockSupplier.get();
        }
    }

    public static enum EnumAssemblyProblem {
        NO_PROBLEM,
        NO_INPUT,
        NO_OUTPUT;

    }
}

