/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.ArrayList;
import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ProgramDrillLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(TileEntityAssemblyController.AssemblySystem system) {
        boolean useAir = true;
        if (!system.getPlatform().getHeldStack().func_190926_b()) {
            if (this.canItemBeDrilled(system.getPlatform().getHeldStack())) {
                system.getDrill().goDrilling();
            } else if (system.getDrill().isIdle() && this.canItemBeLasered(system.getPlatform().getHeldStack())) {
                system.getLaser().startLasering();
            } else if (system.getDrill().isIdle() && system.getLaser().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else if (!system.getExportUnit().isIdle()) {
            useAir = system.getExportUnit().pickupItem(null);
        } else {
            ArrayList<IAssemblyRecipe> recipes = new ArrayList<IAssemblyRecipe>();
            recipes.addAll(this.getRecipeList());
            recipes.addAll(new ProgramDrill().getRecipeList());
            recipes.addAll(new ProgramLaser().getRecipeList());
            useAir = system.getImportUnit().pickupItem(recipes);
        }
        return useAir;
    }

    private boolean canItemBeLasered(ItemStack item) {
        return PneumaticCraftRecipes.assemblyLaserRecipes.values().stream().anyMatch(recipe -> recipe.matches(item));
    }

    private boolean canItemBeDrilled(ItemStack item) {
        return PneumaticCraftRecipes.assemblyDrillRecipes.values().stream().anyMatch(recipe -> recipe.matches(item));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
    }

    @Override
    public Collection<IAssemblyRecipe> getRecipeList() {
        return PneumaticCraftRecipes.assemblyLaserDrillRecipes.values();
    }

    @Override
    public ItemAssemblyProgram getItem() {
        return (ItemAssemblyProgram)ModItems.ASSEMBLY_PROGRAM_DRILL_LASER.get();
    }
}

