/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ProgramLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(TileEntityAssemblyController.AssemblySystem system) {
        boolean useAir = true;
        if (!system.getPlatform().getHeldStack().func_190926_b()) {
            if (this.canItemBeLasered(system.getPlatform().getHeldStack())) {
                system.getLaser().startLasering();
            } else if (system.getLaser().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else {
            useAir = !system.getExportUnit().isIdle() ? system.getExportUnit().pickupItem(null) : system.getImportUnit().pickupItem(this.getRecipeList());
        }
        return useAir;
    }

    private boolean canItemBeLasered(ItemStack item) {
        for (IAssemblyRecipe recipe : this.getRecipeList()) {
            if (!ProgramLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
    }

    @Override
    public Collection<IAssemblyRecipe> getRecipeList() {
        return PneumaticCraftRecipes.assemblyLaserRecipes.values();
    }

    @Override
    public ItemAssemblyProgram getItem() {
        return (ItemAssemblyProgram)ModItems.ASSEMBLY_PROGRAM_LASER.get();
    }
}

