/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.recipes.MachineRecipeHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class AssemblyRecipe
implements IAssemblyRecipe {
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final IAssemblyRecipe.AssemblyProgramType program;

    public AssemblyRecipe(ResourceLocation id, @Nonnull Ingredient input, @Nonnull ItemStack output, IAssemblyRecipe.AssemblyProgramType program) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.program = program;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getInputAmount() {
        return this.input.func_193365_a().length > 0 ? this.input.func_193365_a()[0].func_190916_E() : 0;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public IAssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.program;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return MachineRecipeHandler.Category.ASSEMBLY.getId();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.func_190916_E() >= this.getInputAmount();
    }

    public static void setupRecipeSubtypes(Collection<IAssemblyRecipe> recipes) {
        HashMap<ResourceLocation, IAssemblyRecipe> laser = new HashMap<ResourceLocation, IAssemblyRecipe>();
        HashMap<ResourceLocation, IAssemblyRecipe> drill = new HashMap<ResourceLocation, IAssemblyRecipe>();
        for (IAssemblyRecipe recipe : recipes) {
            switch (recipe.getProgramType()) {
                case LASER: {
                    laser.put(recipe.getId(), recipe);
                    break;
                }
                case DRILL: {
                    drill.put(recipe.getId(), recipe);
                }
            }
        }
        PneumaticCraftRecipes.assemblyLaserRecipes = ImmutableMap.copyOf(laser);
        PneumaticCraftRecipes.assemblyDrillRecipes = ImmutableMap.copyOf(drill);
        PneumaticCraftRecipes.assemblyLaserDrillRecipes = ImmutableMap.copyOf(AssemblyRecipe.calculateAssemblyChain());
    }

    private static Map<ResourceLocation, IAssemblyRecipe> calculateAssemblyChain() {
        HashMap<ResourceLocation, IAssemblyRecipe> r = new HashMap<ResourceLocation, IAssemblyRecipe>();
        for (IAssemblyRecipe r1 : PneumaticCraftRecipes.assemblyDrillRecipes.values()) {
            for (IAssemblyRecipe r2 : PneumaticCraftRecipes.assemblyLaserRecipes.values()) {
                if (!r2.getInput().test(r1.getOutput()) || r1.getOutput().func_190916_E() % r2.getInputAmount() != 0 || r2.getOutput().func_77976_d() < r2.getOutput().func_190916_E() * (r1.getOutput().func_190916_E() / r2.getInputAmount())) continue;
                ItemStack output = r2.getOutput().func_77946_l();
                output.func_190920_e(output.func_190916_E() * (r1.getOutput().func_190916_E() / r2.getInputAmount()));
                String name = r1.getId().func_110623_a() + "/" + r2.getId().func_110623_a();
                ResourceLocation id = PneumaticCraftUtils.RL(name);
                r.put(id, new AssemblyRecipe(id, r1.getInput(), output, IAssemblyRecipe.AssemblyProgramType.DRILL_LASER));
            }
        }
        return r;
    }

    public static class Serializer
    extends AbstractRecipeSerializer<AssemblyRecipe> {
        @Override
        public AssemblyRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            String program = JSONUtils.func_151200_h((JsonObject)json, (String)"program").toUpperCase();
            try {
                IAssemblyRecipe.AssemblyProgramType programType = IAssemblyRecipe.AssemblyProgramType.valueOf(program);
                Validate.isTrue((programType != IAssemblyRecipe.AssemblyProgramType.DRILL_LASER ? 1 : 0) != 0, (String)"'drill_laser' may not be used in recipe JSON!", (Object[])new Object[0]);
                return new AssemblyRecipe(recipeId, input, result, programType);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e.getMessage());
            }
        }

        @Override
        @Nullable
        public AssemblyRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack out = buffer.func_150791_c();
            IAssemblyRecipe.AssemblyProgramType program = IAssemblyRecipe.AssemblyProgramType.values()[buffer.func_150792_a()];
            return new AssemblyRecipe(recipeId, input, out, program);
        }

        @Override
        public void write(PacketBuffer buffer, AssemblyRecipe recipe) {
            super.write(buffer, recipe);
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.func_150787_b(recipe.program.ordinal());
        }
    }
}

