/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.recipes.MachineRecipeHandler;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public class BasicThermopneumaticProcessingPlantRecipe
implements IThermopneumaticProcessingPlantRecipe {
    private final ResourceLocation id;
    private final FluidIngredient inputFluid;
    private final FluidStack outputFluid;
    private final Ingredient inputItem;
    private final float requiredPressure;
    private final boolean exothermic;
    private final TemperatureRange operatingTemperature;
    private final ItemStack outputItem;

    public BasicThermopneumaticProcessingPlantRecipe(ResourceLocation id, @Nonnull FluidIngredient inputFluid, @Nullable Ingredient inputItem, FluidStack outputFluid, ItemStack outputItem, TemperatureRange operatingTemperature, float requiredPressure, boolean exothermic) {
        this.id = id;
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.exothermic = exothermic;
        Validate.isTrue((!inputFluid.func_203189_d() || !inputItem.func_203189_d() ? 1 : 0) != 0, (String)"At least on of input fluid or input item must be non-empty!", (Object[])new Object[0]);
    }

    @Override
    public boolean matches(FluidStack fluidStack, @Nonnull ItemStack stack) {
        return !(this.inputFluid != null && !this.inputFluid.testFluid(fluidStack) || this.inputItem != null && !this.inputItem.test(stack));
    }

    @Override
    public TemperatureRange getOperatingTemperature() {
        return this.operatingTemperature;
    }

    @Override
    public float getRequiredPressure() {
        return this.requiredPressure;
    }

    @Override
    public FluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    @Override
    @Nonnull
    public Ingredient getInputItem() {
        return this.inputItem;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public boolean isExothermic() {
        return this.exothermic;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return MachineRecipeHandler.Category.THERMO_PLANT.getId();
    }

    public static class Serializer
    extends AbstractRecipeSerializer<BasicThermopneumaticProcessingPlantRecipe> {
        @Override
        public BasicThermopneumaticProcessingPlantRecipe read(ResourceLocation recipeId, JsonObject json) {
            TemperatureRange range;
            ItemStack itemOutput;
            Ingredient fluidInput;
            Ingredient itemInput = json.has("item_input") ? Ingredient.func_199802_a((JsonElement)json.get("item_input")) : Ingredient.field_193370_a;
            Ingredient ingredient = fluidInput = json.has("fluid_input") ? FluidIngredient.func_199802_a((JsonElement)json.get("fluid_input")) : Ingredient.field_193370_a;
            if (itemInput.func_203189_d() && fluidInput.func_203189_d()) {
                throw new JsonSyntaxException("Must have at least one of item_input and/or fluid_input!");
            }
            FluidStack fluidOutput = json.has("fluid_output") ? ModCraftingHelper.fluidStackFromJSON(json.getAsJsonObject("fluid_output")) : FluidStack.EMPTY;
            ItemStack itemStack = itemOutput = json.has("item_output") ? ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"item_output")) : ItemStack.field_190927_a;
            if (fluidOutput.isEmpty() && itemOutput.func_190926_b()) {
                throw new JsonSyntaxException("Must have at least one of item_output and/or fluid_output!");
            }
            if (!json.has("min_temp") && !json.has("max_temp")) {
                range = TemperatureRange.any();
            } else {
                int minTemp = JSONUtils.func_151208_a((JsonObject)json, (String)"min_temp", (int)373);
                int maxTemp = JSONUtils.func_151208_a((JsonObject)json, (String)"max_temp", (int)Integer.MAX_VALUE);
                range = TemperatureRange.of(minTemp, maxTemp);
            }
            float pressure = JSONUtils.func_151221_a((JsonObject)json, (String)"pressure", (float)0.0f);
            boolean exothermic = JSONUtils.func_151209_a((JsonObject)json, (String)"exothermic", (boolean)false);
            return new BasicThermopneumaticProcessingPlantRecipe(recipeId, (FluidIngredient)fluidInput, itemInput, fluidOutput, itemOutput, range, pressure, exothermic);
        }

        @Override
        @Nullable
        public BasicThermopneumaticProcessingPlantRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            TemperatureRange range = TemperatureRange.of(buffer.func_150792_a(), buffer.func_150792_a());
            float pressure = buffer.readFloat();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidIngredient fluidIn = FluidIngredient.readFromPacket(buffer);
            FluidStack fluidOut = FluidStack.readFromPacket((PacketBuffer)buffer);
            ItemStack itemOutput = buffer.func_150791_c();
            boolean exothermic = buffer.readBoolean();
            return new BasicThermopneumaticProcessingPlantRecipe(recipeId, fluidIn, input, fluidOut, itemOutput, range, pressure, exothermic);
        }

        @Override
        public void write(PacketBuffer buffer, BasicThermopneumaticProcessingPlantRecipe recipe) {
            super.write(buffer, recipe);
            buffer.func_150787_b(recipe.operatingTemperature.getMin());
            buffer.func_150787_b(recipe.operatingTemperature.getMax());
            buffer.writeFloat(recipe.requiredPressure);
            recipe.inputItem.func_199564_a(buffer);
            recipe.inputFluid.writeToPacket(buffer);
            recipe.outputFluid.writeToPacket(buffer);
            buffer.func_150788_a(recipe.outputItem);
            buffer.writeBoolean(recipe.exothermic);
        }
    }
}

