/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.recipes.MachineRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ExplosionCraftingRecipe
implements IExplosionCraftingRecipe {
    private static final NonNullList<ItemStack> EMPTY_RESULT = NonNullList.func_191196_a();
    private final ResourceLocation id;
    private final Ingredient input;
    private final List<ItemStack> outputs;
    private final int lossRate;

    public ExplosionCraftingRecipe(ResourceLocation id, Ingredient input, int lossRate, ItemStack ... outputs) {
        this.id = id;
        this.input = input;
        this.outputs = Arrays.asList(outputs);
        this.lossRate = lossRate;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getAmount() {
        return this.input.func_193365_a().length > 0 ? this.input.func_193365_a()[0].func_190916_E() : 0;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public int getLossRate() {
        return this.lossRate;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.func_190916_E() >= this.getAmount();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return MachineRecipeHandler.Category.EXPLOSION_CRAFTING.getId();
    }

    public static NonNullList<ItemStack> tryToCraft(ItemStack stack) {
        for (IExplosionCraftingRecipe recipe : PneumaticCraftRecipes.explosionCraftingRecipes.values()) {
            if (!recipe.matches(stack)) continue;
            return ExplosionCraftingRecipe.createOutput(recipe, stack);
        }
        return EMPTY_RESULT;
    }

    private static NonNullList<ItemStack> createOutput(IExplosionCraftingRecipe recipe, ItemStack stack) {
        Random rand = new Random();
        int lossRate = recipe.getLossRate();
        NonNullList res = NonNullList.func_191196_a();
        int inputCount = Math.round((float)stack.func_190916_E() / (float)recipe.getAmount());
        if (inputCount >= 3 || rand.nextDouble() >= (double)lossRate / 100.0) {
            for (ItemStack s : recipe.getOutputs()) {
                ItemStack newStack = s.func_77946_l();
                if (inputCount >= 3) {
                    newStack.func_190920_e((int)((double)inputCount * (rand.nextDouble() * Math.min((double)lossRate * 0.02, 0.2) + (Math.max(0.9, 1.0 - (double)lossRate * 0.01) - (double)lossRate * 0.01))));
                }
                res.add((Object)newStack);
            }
        }
        return res;
    }

    public static class Serializer
    extends AbstractRecipeSerializer<ExplosionCraftingRecipe> {
        @Override
        public ExplosionCraftingRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int loss_rate = JSONUtils.func_151208_a((JsonObject)json, (String)"loss_rate", (int)0);
            return new ExplosionCraftingRecipe(recipeId, input, loss_rate, result);
        }

        @Override
        @Nullable
        public ExplosionCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int nOutputs = buffer.func_150792_a();
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            for (int i = 0; i < nOutputs; ++i) {
                l.add(buffer.func_150791_c());
            }
            int lossRate = buffer.func_150792_a();
            return new ExplosionCraftingRecipe(recipeId, input, lossRate, l.toArray(new ItemStack[0]));
        }

        @Override
        public void write(PacketBuffer buffer, ExplosionCraftingRecipe recipe) {
            super.write(buffer, recipe);
            recipe.input.func_199564_a(buffer);
            buffer.func_150787_b(recipe.outputs.size());
            recipe.outputs.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
            buffer.func_150787_b(recipe.lossRate);
        }
    }
}

