/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.IHeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.recipes.MachineRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class HeatFrameCoolingRecipe
implements IHeatFrameCoolingRecipe {
    private final ResourceLocation id;
    public final Ingredient input;
    private final int temperature;
    public final ItemStack output;
    private final float bonusMultiplier;
    private final float bonusLimit;

    public HeatFrameCoolingRecipe(ResourceLocation id, Ingredient input, int temperature, ItemStack output) {
        this(id, input, temperature, output, 0.0f, 1.0f);
    }

    public HeatFrameCoolingRecipe(ResourceLocation id, Ingredient input, int temperature, ItemStack output, float bonusMultiplier, float bonusLimit) {
        this.id = id;
        this.input = input;
        this.temperature = temperature;
        this.output = output;
        this.bonusMultiplier = bonusMultiplier;
        this.bonusLimit = bonusLimit;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getThresholdTemperature() {
        return this.temperature;
    }

    @Override
    public float getBonusMultiplier() {
        return this.bonusMultiplier;
    }

    @Override
    public float getBonusLimit() {
        return this.bonusLimit;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return MachineRecipeHandler.Category.HEAT_FRAME_COOLING.getId();
    }

    public static class Serializer
    extends AbstractRecipeSerializer<HeatFrameCoolingRecipe> {
        @Override
        public HeatFrameCoolingRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int maxTemp = JSONUtils.func_151208_a((JsonObject)json, (String)"max_temp", (int)273);
            float bonusMultiplier = 0.0f;
            float bonusLimit = 1.0f;
            if (json.has("bonus_output")) {
                JsonObject bonus = json.getAsJsonObject("bonus_output");
                bonusMultiplier = JSONUtils.func_151217_k((JsonObject)bonus, (String)"multiplier");
                bonusLimit = JSONUtils.func_151217_k((JsonObject)bonus, (String)"limit");
            }
            return new HeatFrameCoolingRecipe(recipeId, input, maxTemp, result, bonusMultiplier, bonusLimit);
        }

        @Override
        @Nullable
        public HeatFrameCoolingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int temperature = buffer.readInt();
            ItemStack out = buffer.func_150791_c();
            float bonusMultiplier = buffer.readFloat();
            float bonusLimit = buffer.readFloat();
            return new HeatFrameCoolingRecipe(recipeId, input, temperature, out, bonusMultiplier, bonusLimit);
        }

        @Override
        public void write(PacketBuffer buffer, HeatFrameCoolingRecipe recipe) {
            super.write(buffer, recipe);
            recipe.input.func_199564_a(buffer);
            buffer.writeInt(recipe.temperature);
            buffer.func_150788_a(recipe.output);
            buffer.writeFloat(recipe.bonusMultiplier);
            buffer.writeFloat(recipe.bonusLimit);
        }
    }
}

