/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PressureChamberDisenchantingRecipe
implements IPressureChamberRecipe {
    public static final ResourceLocation ID = PneumaticCraftUtils.RL("pressure_chamber_disenchanting");

    @Override
    public float getCraftingPressure() {
        return -0.75f;
    }

    @Override
    public Collection<Integer> findIngredients(IItemHandlerModifiable chamberHandler) {
        int bookSlot = -1;
        int itemSlot = -1;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack stack = chamberHandler.getStackInSlot(i);
            if (stack.func_77973_b() == Items.field_151122_aG) {
                bookSlot = i;
            } else if (stack.func_77973_b() != Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)stack).size() > 0) {
                itemSlot = i;
            }
            if (bookSlot < 0 || itemSlot < 0) continue;
            return ImmutableList.of((Object)bookSlot, (Object)itemSlot);
        }
        return Collections.emptyList();
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(IItemHandlerModifiable chamberHandler, List<Integer> ingredientSlots) {
        ItemStack book = chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, false);
        ItemStack enchantedStack = chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, false);
        if (book.func_190926_b() || enchantedStack.func_190926_b()) {
            return NonNullList.func_191196_a();
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)enchantedStack);
        ArrayList l = new ArrayList(enchantments.keySet());
        Enchantment strippedEnchantment = (Enchantment)l.get(new Random().nextInt(l.size()));
        int level = (Integer)enchantments.get(strippedEnchantment);
        enchantments.remove(strippedEnchantment);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)enchantedStack);
        ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)strippedEnchantment, (Object)level), (ItemStack)enchantedBook);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{enchantedBook, enchantedStack});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack pick = new ItemStack((IItemProvider)Items.field_151046_w);
        pick.func_77966_a(Enchantments.field_185308_t, 1);
        return ImmutableList.of((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{pick}), (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151122_aG}));
    }

    @Override
    public NonNullList<ItemStack> getResultForDisplay() {
        ItemStack pick = new ItemStack((IItemProvider)Items.field_151046_w);
        ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
        book.func_77966_a(Enchantments.field_185308_t, 1);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{pick, book});
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() != Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)stack).size() > 0;
    }

    @Override
    public String getTooltipKey(boolean input, int slot) {
        switch (slot) {
            case 0: {
                return "gui.nei.tooltip.vacuumEnchantItem";
            }
            case 2: {
                return "gui.nei.tooltip.vacuumEnchantItemOut";
            }
            case 3: {
                return "gui.nei.tooltip.vacuumEnchantBookOut";
            }
        }
        return "";
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return ID;
    }

    public static class Serializer
    extends AbstractRecipeSerializer<PressureChamberDisenchantingRecipe> {
        @Override
        public PressureChamberDisenchantingRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new PressureChamberDisenchantingRecipe();
        }

        @Override
        @Nullable
        public PressureChamberDisenchantingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new PressureChamberDisenchantingRecipe();
        }

        @Override
        public void write(PacketBuffer buffer, PressureChamberDisenchantingRecipe recipe) {
            super.write(buffer, recipe);
        }
    }
}

