/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PressureChamberEnchantingRecipe
implements IPressureChamberRecipe {
    public static final ResourceLocation ID = PneumaticCraftUtils.RL("pressure_chamber_enchanting");

    @Override
    public float getCraftingPressure() {
        return 2.0f;
    }

    @Override
    public Collection<Integer> findIngredients(IItemHandlerModifiable chamberHandler) {
        ItemStack stack;
        int i;
        ArrayList<Integer> bookSlots = new ArrayList<Integer>();
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (stack.func_77973_b() != Items.field_151134_bR) continue;
            bookSlots.add(i);
        }
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (!stack.func_77956_u() && !stack.func_77948_v()) continue;
            Iterator iterator = bookSlots.iterator();
            while (iterator.hasNext()) {
                int bookSlot = (Integer)iterator.next();
                ItemStack enchantedBook = chamberHandler.getStackInSlot(bookSlot);
                if (!this.isApplicable(enchantedBook, stack)) continue;
                return ImmutableList.of((Object)bookSlot, (Object)i);
            }
        }
        return Collections.emptyList();
    }

    private boolean isApplicable(ItemStack enchantedBook, ItemStack enchantable) {
        Map bookMap = EnchantmentHelper.func_82781_a((ItemStack)enchantedBook);
        for (Map.Entry entry : bookMap.entrySet()) {
            if (!((Enchantment)entry.getKey()).func_92089_a(enchantable) || EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)entry.getKey()), (ItemStack)enchantable) >= (Integer)entry.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(IItemHandlerModifiable chamberHandler, List<Integer> ingredientSlots) {
        ItemStack enchantedBook = chamberHandler.getStackInSlot(ingredientSlots.get(0).intValue());
        ItemStack enchantable = chamberHandler.getStackInSlot(ingredientSlots.get(1).intValue()).func_77946_l();
        Map bookMap = EnchantmentHelper.func_82781_a((ItemStack)enchantedBook);
        bookMap.forEach((enchantment, level) -> {
            if (enchantment.func_92089_a(enchantable)) {
                enchantable.func_77966_a(enchantment, level.intValue());
            }
        });
        chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, false);
        chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, false);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151122_aG), enchantable});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack enchBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        enchBook.func_77966_a(Enchantments.field_185308_t, 1);
        return ImmutableList.of((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151046_w}), (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{enchBook}));
    }

    @Override
    public NonNullList<ItemStack> getResultForDisplay() {
        ItemStack pick = new ItemStack((IItemProvider)Items.field_151046_w);
        pick.func_77966_a(Enchantments.field_185308_t, 1);
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{pick, book});
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151134_bR || stack.func_77956_u();
    }

    @Override
    public String getTooltipKey(boolean input, int slot) {
        switch (slot) {
            case 0: {
                return "gui.nei.tooltip.pressureEnchantItem";
            }
            case 1: {
                return "gui.nei.tooltip.pressureEnchantBook";
            }
            case 2: {
                return "gui.nei.tooltip.pressureEnchantItemOut";
            }
            case 3: {
                return "gui.nei.tooltip.pressureEnchantBookOut";
            }
        }
        return "";
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return ID;
    }

    public static class Serializer
    extends AbstractRecipeSerializer<PressureChamberEnchantingRecipe> {
        @Override
        public PressureChamberEnchantingRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new PressureChamberEnchantingRecipe();
        }

        @Override
        @Nullable
        public PressureChamberEnchantingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new PressureChamberEnchantingRecipe();
        }

        @Override
        public void write(PacketBuffer buffer, PressureChamberEnchantingRecipe recipe) {
            super.write(buffer, recipe);
        }
    }
}

