/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.IRefineryRecipe;
import me.desht.pneumaticcraft.common.recipes.AbstractRecipeSerializer;
import me.desht.pneumaticcraft.common.recipes.MachineRecipeHandler;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipe
implements IRefineryRecipe {
    public final FluidIngredient input;
    public final List<FluidStack> outputs;
    private ResourceLocation id;
    private final TemperatureRange operatingTemp;

    public RefineryRecipe(ResourceLocation id, FluidIngredient input, TemperatureRange operatingTemp, FluidStack ... outputs) {
        this.id = id;
        this.operatingTemp = operatingTemp;
        if (outputs.length < 2 || outputs.length > 4) {
            throw new IllegalArgumentException("Recipe must have between 2 and 4 (inclusive) outputs");
        }
        this.input = input;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
    }

    @Override
    public FluidIngredient getInput() {
        return this.input;
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public TemperatureRange getOperatingTemp() {
        return this.operatingTemp;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getRecipeType() {
        return MachineRecipeHandler.Category.REFINERY.getId();
    }

    public static class Serializer
    extends AbstractRecipeSerializer<RefineryRecipe> {
        @Override
        public RefineryRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = FluidIngredient.func_199802_a((JsonElement)json.get("input"));
            int minTemp = JSONUtils.func_151208_a((JsonObject)json, (String)"min_temp", (int)373);
            int maxTemp = JSONUtils.func_151208_a((JsonObject)json, (String)"max_temp", (int)Integer.MAX_VALUE);
            JsonArray outputs = json.get("results").getAsJsonArray();
            if (outputs.size() < 2 || outputs.size() > 4) {
                throw new JsonSyntaxException("must be between 2 and 4 (inclusive) output fluids!");
            }
            ArrayList<FluidStack> results = new ArrayList<FluidStack>();
            for (JsonElement element : outputs) {
                results.add(ModCraftingHelper.fluidStackFromJSON(element.getAsJsonObject()));
            }
            return new RefineryRecipe(recipeId, (FluidIngredient)input, TemperatureRange.of(minTemp, maxTemp), results.toArray(new FluidStack[0]));
        }

        @Override
        @Nullable
        public RefineryRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            FluidIngredient input = FluidIngredient.readFromPacket(buffer);
            TemperatureRange range = TemperatureRange.of(buffer.func_150792_a(), buffer.func_150792_a());
            int nOutputs = buffer.func_150792_a();
            FluidStack[] outputs = new FluidStack[nOutputs];
            for (int i = 0; i < nOutputs; ++i) {
                outputs[i] = FluidStack.readFromPacket((PacketBuffer)buffer);
            }
            return new RefineryRecipe(recipeId, input, range, outputs);
        }

        @Override
        public void write(PacketBuffer buffer, RefineryRecipe recipe) {
            super.write(buffer, recipe);
            recipe.input.writeToPacket(buffer);
            buffer.func_150787_b(recipe.operatingTemp.getMin());
            buffer.func_150787_b(recipe.operatingTemp.getMax());
            buffer.func_150787_b(recipe.outputs.size());
            recipe.outputs.forEach(f -> f.writeToPacket(buffer));
        }
    }
}

