/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.common.config.aux.ThirdPartyConfig;
import me.desht.pneumaticcraft.common.thirdparty.GenericIntegrationHandler;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IRegistryListener;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TheOneProbe;
import me.desht.pneumaticcraft.common.thirdparty.waila.Waila;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.ModList;

public class ThirdPartyManager {
    private static final ThirdPartyManager INSTANCE = new ThirdPartyManager();
    private final List<IThirdParty> thirdPartyMods = new ArrayList<IThirdParty>();
    public static boolean computerCraftLoaded;
    public IDocsProvider docsProvider = new IDocsProvider.NoDocsProvider();
    private GenericIntegrationHandler generic = new GenericIntegrationHandler();

    public static ThirdPartyManager instance() {
        return INSTANCE;
    }

    public void index() {
        HashMap<String, Class> thirdPartyClasses = new HashMap<String, Class>();
        try {
            thirdPartyClasses.put("waila", Waila.class);
            thirdPartyClasses.put("theoneprobe", TheOneProbe.class);
            thirdPartyClasses.put("curios", Curios.class);
            thirdPartyClasses.put("patchouli", Patchouli.class);
        }
        catch (Throwable e) {
            Log.error("A class loader loaded a class where we didn't expect it to do so! Please report, as third party content is broken.", new Object[0]);
            e.printStackTrace();
        }
        ThirdPartyConfig.setupDefaults(thirdPartyClasses.keySet());
        Set enabledThirdParty = thirdPartyClasses.keySet().stream().filter(ThirdPartyConfig::isEnabled).collect(Collectors.toSet());
        Log.info("Thirdparty integration activated for [" + Strings.join(enabledThirdParty, (String)", ") + "]", new Object[0]);
        for (Map.Entry entry : thirdPartyClasses.entrySet()) {
            if (!enabledThirdParty.contains(entry.getKey()) || !ModList.get().isLoaded((String)entry.getKey())) continue;
            try {
                this.thirdPartyMods.add((IThirdParty)((Class)entry.getValue()).newInstance());
            }
            catch (Throwable e) {
                Log.error("Failed to instantiate third party handler!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void onItemRegistry(Item item) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof IRegistryListener)) continue;
            ((IRegistryListener)((Object)thirdParty)).onItemRegistry(item);
        }
    }

    public void onBlockRegistry(Block block) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof IRegistryListener)) continue;
            ((IRegistryListener)((Object)thirdParty)).onBlockRegistry(block);
        }
    }

    public void preInit() {
        this.index();
        this.generic.preInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.preInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PreInit phase!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void init() {
        this.generic.init();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.init();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the Init phase!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        this.generic.postInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.postInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PostInit phase!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void clientPreInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientPreInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void clientInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientInit();
                if (!(thirdParty instanceof IDocsProvider)) continue;
                this.docsProvider = (IDocsProvider)((Object)thirdParty);
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side on the init!", new Object[0]);
                e.printStackTrace();
            }
        }
    }
}

