/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.common.block.BlockAssemblyController;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class JEIAssemblyControllerCategory
implements IRecipeCategory<IAssemblyRecipe> {
    private final String localizedName;
    private final IDrawable background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_ASSEMBLY_CONTROLLER, 5, 11, 166, 130);
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.ASSEMBLY_CONTROLLER.get()));
    private final IDrawableAnimated progressBar;

    JEIAssemblyControllerCategory() {
        this.localizedName = I18n.func_135052_a((String)((BlockAssemblyController)ModBlocks.ASSEMBLY_CONTROLLER.get()).func_149739_a(), (Object[])new Object[0]);
        IDrawableStatic d = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_ASSEMBLY_CONTROLLER, 173, 0, 24, 17);
        this.progressBar = JEIPlugin.jeiHelpers.getGuiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.ASSEMBLY_CONTROLLER;
    }

    public Class<? extends IAssemblyRecipe> getRecipeClass() {
        return IAssemblyRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IAssemblyRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> input = new ArrayList<Ingredient>();
        input.add(recipe.getInput());
        input.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemAssemblyProgram.fromProgramType(recipe.getProgramType())}));
        Arrays.stream(this.getMachinesFromEnum(AssemblyProgram.fromRecipe(recipe).getRequiredMachines())).map(xva$0 -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{xva$0})).forEach(input::add);
        ingredients.setInputIngredients(input);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IAssemblyRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 28, 65);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(2, true, 132, 21);
        recipeLayout.getItemStacks().set(2, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        int l = ingredients.getInputs(VanillaTypes.ITEM).size() - 2;
        for (int i = 0; i < l; ++i) {
            recipeLayout.getItemStacks().init(i + 3, true, 5 + i * 18, 25);
            recipeLayout.getItemStacks().set(i + 3, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i + 2));
        }
        recipeLayout.getItemStacks().init(1, false, 95, 65);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(IAssemblyRecipe recipe, double mouseX, double mouseY) {
        this.progressBar.draw(68, 75);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_211126_b("Required Machines", 5.0f, 15.0f, -12566464);
        fontRenderer.func_211126_b("Prog.", 129.0f, 9.0f, -12566464);
    }

    private ItemStack[] getMachinesFromEnum(AssemblyProgram.EnumMachine[] requiredMachines) {
        ItemStack[] machineStacks = new ItemStack[requiredMachines.length];
        for (int i = 0; i < requiredMachines.length; ++i) {
            machineStacks[i] = new ItemStack((IItemProvider)requiredMachines[i].getMachineBlock());
        }
        return machineStacks;
    }

    static Collection<IAssemblyRecipe> getAllRecipes() {
        ArrayList<IAssemblyRecipe> res = new ArrayList<IAssemblyRecipe>();
        res.addAll(PneumaticCraftRecipes.assemblyDrillRecipes.values());
        res.addAll(PneumaticCraftRecipes.assemblyLaserRecipes.values());
        res.addAll(PneumaticCraftRecipes.assemblyLaserDrillRecipes.values());
        return res;
    }
}

