/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IHeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class JEIHeatFrameCoolingCategory
implements IRecipeCategory<IHeatFrameCoolingRecipe> {
    private final String localizedName = I18n.func_135052_a((String)"gui.nei.title.heatFrameCooling", (Object[])new Object[0]);
    private final IDrawable background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_MISC_RECIPES, 0, 0, 82, 18);
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.HEAT_FRAME.get()));
    private final IDrawableAnimated progressBar;

    JEIHeatFrameCoolingCategory() {
        IDrawableStatic d = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_MISC_RECIPES, 82, 0, 38, 17);
        this.progressBar = JEIPlugin.jeiHelpers.getGuiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.HEAT_FRAME_COOLING;
    }

    public Class<? extends IHeatFrameCoolingRecipe> getRecipeClass() {
        return IHeatFrameCoolingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IHeatFrameCoolingRecipe recipe, double mouseX, double mouseY) {
        this.progressBar.draw(22, 0);
    }

    public void setIngredients(IHeatFrameCoolingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getInput()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IHeatFrameCoolingRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 64, 0);
        recipeLayout.getItemStacks().set(1, recipe.getOutput());
    }

    public List<String> getTooltipStrings(IHeatFrameCoolingRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> res = new ArrayList<String>();
        if (mouseX >= 23.0 && mouseX <= 60.0) {
            res.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"gui.nei.recipe.heatFrameCooling", (Object[])new Object[]{recipe.getThresholdTemperature() - 273}), 40));
            if (recipe.getBonusMultiplier() > 0.0f) {
                String bonus = TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.nei.recipe.heatFrameCooling.bonus", (Object[])new Object[]{Float.valueOf(recipe.getBonusMultiplier() * 100.0f), recipe.getOutput().func_200301_q().func_150254_d(), recipe.getThresholdTemperature() - 273, Float.valueOf(recipe.getBonusLimit() + 1.0f)});
                res.addAll(PneumaticCraftUtils.splitString(bonus, 40));
            }
        }
        return res;
    }

    static Collection<IHeatFrameCoolingRecipe> getAllRecipes() {
        return PneumaticCraftRecipes.heatFrameCoolingRecipes.values();
    }
}

