/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractShapelessExtension
implements ICustomCraftingCategoryExtension {
    private final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private final ItemStack output;
    private final ResourceLocation name;

    AbstractShapelessExtension(SpecialRecipe recipe, ItemStack result, IItemProvider ... items) {
        for (IItemProvider provider : items) {
            this.inputs.add(Collections.singletonList(new ItemStack(provider)));
        }
        this.output = result;
        this.name = recipe.func_199560_c();
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        recipeLayout.getItemStacks().set(ingredients);
        recipeLayout.setShapeless();
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

