/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.common.block.BlockPressureChamberInterface;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberValve;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class Patchouli
implements IThirdParty,
IDocsProvider {
    private static Screen prevGui;

    @Override
    public void clientPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void clientInit() {
        PatchouliAPI.IPatchouliAPI papi = PatchouliAPI.instance;
        this.setConfigFlags();
        IStateMatcher edge = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_WALL.get(), this::validEdge);
        IStateMatcher wall = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_WALL.get(), this::validFace);
        IStateMatcher glass = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_GLASS.get(), this::validFace);
        IStateMatcher valve = papi.predicateMatcher((BlockState)((BlockPressureChamberValve)ModBlocks.PRESSURE_CHAMBER_VALVE.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH), this::validFace);
        IStateMatcher valveUp = papi.predicateMatcher((BlockState)((BlockPressureChamberValve)ModBlocks.PRESSURE_CHAMBER_VALVE.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.UP), this::validFace);
        IStateMatcher intI = papi.predicateMatcher((BlockState)((BlockPressureChamberInterface)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST), this::validFace);
        IStateMatcher intO = papi.predicateMatcher((BlockState)((BlockPressureChamberInterface)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST), this::validFace);
        IMultiblock pc3 = papi.makeMultiblock((String[][])new String[][]{{"WWW", "WWW", "WWW"}, {"WIW", "VAF", "WIW"}, {"WWW", "W0W", "WWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticCraftUtils.RL("pressure_chamber_3"), pc3);
        IMultiblock pc4 = papi.makeMultiblock((String[][])new String[][]{{"WWWW", "WWWW", "WWWW", "WWWW"}, {"WFFW", "VAAF", "FAAF", "WFFW"}, {"WFFW", "VAAF", "FAAF", "WIOW"}, {"WWWW", "W0WW", "WWWW", "WWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(false);
        papi.registerMultiblock(PneumaticCraftUtils.RL("pressure_chamber_4"), pc4);
        IMultiblock pc5 = papi.makeMultiblock((String[][])new String[][]{{"WWWWW", "WWVWW", "WVWVW", "WWVWW", "WWWWW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WFFFW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WWWWW", "WWWWW", "WW0WW", "WWWWW", "WWWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valveUp, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticCraftUtils.RL("pressure_chamber_5"), pc5);
    }

    private boolean validEdge(BlockState state) {
        return state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_WALL.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_GLASS.get();
    }

    private boolean validFace(BlockState state) {
        return state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_WALL.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_GLASS.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_INTERFACE.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_VALVE.get();
    }

    private void setConfigFlags() {
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:liquidHopperDispenser", PNCConfig.Common.Machines.liquidHopperDispenser);
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:omniHopperDispenser", PNCConfig.Common.Machines.omniHopperDispenser);
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:electricCompressorEnabled", false);
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:pneumaticGeneratorEnabled", false);
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("pneumaticcraft")) {
            this.setConfigFlags();
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (prevGui != null) {
            event.setGui(prevGui);
            prevGui = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openBookGui(ResourceLocation bookRes, String entryId) {
        BookEntry entry;
        Screen prev = Minecraft.func_71410_x().field_71462_r;
        Book book = (Book)BookRegistry.INSTANCE.books.get(bookRes);
        if (book != null && (entry = (BookEntry)book.contents.entries.get(new ResourceLocation(bookRes.func_110624_b(), entryId))) != null) {
            GuiBook curr = book.contents.getCurrentGui();
            book.contents.currentGui = new GuiBookEntry(book, entry, 0);
            book.contents.guiStack.push(curr);
            book.contents.openLexiconGui(book.contents.getCurrentGui(), true);
            prevGui = prev;
        }
    }

    @Override
    public void showWidgetDocs(String path) {
        Patchouli.openBookGui(PneumaticCraftUtils.RL("book"), "programming/" + path);
    }

    @Override
    public boolean docsProviderInstalled() {
        return true;
    }
}

