/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.util.ItemStackUtil;

public class ProcessorAssemblySystem
implements IComponentProcessor {
    private IAssemblyRecipe recipe = null;

    public void setup(IVariableProvider<String> iVariableProvider) {
        ItemStack result = PatchouliAPI.instance.deserializeItemStack((String)iVariableProvider.get("item"));
        this.recipe = this.findRecipe(result);
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        ItemStack programStack = new ItemStack((IItemProvider)ItemAssemblyProgram.fromProgramType(this.recipe.getProgramType()));
        switch (key) {
            case "input": {
                return ItemStackUtil.serializeIngredient((Ingredient)this.recipe.getInput());
            }
            case "output": {
                return ItemStackUtil.serializeStack((ItemStack)this.recipe.getOutput());
            }
            case "program": {
                return ItemStackUtil.serializeStack((ItemStack)programStack);
            }
            case "name": {
                return this.recipe.getOutput().func_200301_q().func_150254_d();
            }
            case "desc": {
                return I18n.func_135052_a((String)"patchouli.processor.assembly.desc", (Object[])new Object[]{this.recipe.getOutput().func_200301_q().func_150254_d(), programStack.func_200301_q().func_150254_d()});
            }
        }
        return null;
    }

    private IAssemblyRecipe findRecipe(ItemStack result) {
        for (IAssemblyRecipe recipe : PneumaticCraftRecipes.assemblyLaserDrillRecipes.values()) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            return recipe;
        }
        for (IAssemblyRecipe recipe : PneumaticCraftRecipes.assemblyLaserRecipes.values()) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            return recipe;
        }
        for (IAssemblyRecipe recipe : PneumaticCraftRecipes.assemblyDrillRecipes.values()) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            return recipe;
        }
        return null;
    }
}

