/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SemiblockProvider {

    public static class Component
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            CompoundNBT tag = accessor.getServerData().func_74775_l("semiBlocks");
            for (String name : tag.func_150296_c()) {
                try {
                    int entityId = Integer.parseInt(name);
                    ISemiBlock entity = ISemiBlock.byTrackingId(accessor.getWorld(), entityId);
                    if (entity == null) continue;
                    tooltip.add(new StringTextComponent("[").func_150257_a(entity.getDisplayName()).func_150257_a((ITextComponent)new StringTextComponent("]")).func_211708_a(TextFormatting.YELLOW));
                    entity.addTooltip(tooltip, accessor.getPlayer(), tag.func_74775_l(name), accessor.getPlayer().func_70093_af());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public static class Data
    implements IServerDataProvider<TileEntity> {
        public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
            CompoundNBT tag = new CompoundNBT();
            SemiblockTracker.getInstance().getAllSemiblocks(world, tileEntity.func_174877_v()).forEach(semiBlock -> {
                NonNullList<ItemStack> drops = semiBlock.getDrops();
                if (!drops.isEmpty()) {
                    tag.func_218657_a(Integer.toString(semiBlock.getTrackingId()), (INBT)semiBlock.serializeNBT(new CompoundNBT()));
                }
            });
            compoundNBT.func_218657_a("semiBlocks", (INBT)tag);
        }
    }
}

