/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;

public abstract class TileEntityAbstractHopper
extends TileEntityTickableBase
implements IRedstoneControlled,
IComparatorSupport,
INamedContainerProvider {
    private int lastComparatorValue = -1;
    @GuiSynced
    public int redstoneMode;
    private int cooldown;
    @GuiSynced
    int leaveMaterialCount;
    @DescSynced
    public boolean isCreative;
    private boolean wasCreative = false;
    Direction inputDir = Direction.UP;

    TileEntityAbstractHopper(TileEntityType type) {
        super(type, 4);
    }

    public Direction getInputDirection() {
        return (Direction)this.func_195044_w().func_177229_b(BlockOmnidirectionalHopper.INPUT_FACING);
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.isCreative = this.getUpgrades(EnumUpgrade.CREATIVE) > 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inputDir = this.getInputDirection();
        if (!this.func_145831_w().field_72995_K && --this.cooldown <= 0 && this.redstoneAllows()) {
            int maxItems = this.getMaxItems();
            boolean success = this.doImport(maxItems);
            int n = this.cooldown = (success |= this.doExport(maxItems)) ? this.getItemTransferInterval() : 8;
            if (this.lastComparatorValue != this.getComparatorValueInternal()) {
                this.lastComparatorValue = this.getComparatorValueInternal();
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        boolean rerender = this.wasCreative != this.isCreative;
        this.wasCreative = this.isCreative;
        return rerender;
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(EnumUpgrade.SPEED);
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(EnumUpgrade.SPEED));
    }

    protected abstract boolean doExport(int var1);

    protected abstract boolean doImport(int var1);

    protected abstract int getComparatorValueInternal();

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("leaveMaterialCount", this.leaveMaterialCount);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.leaveMaterialCount = tag.func_74764_b("leaveMaterial") ? (int)((byte)(tag.func_74767_n("leaveMaterial") ? 1 : 0)) : tag.func_74762_e("leaveMaterialCount");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        switch (tag) {
            case "redstone": {
                ++this.redstoneMode;
                if (this.redstoneMode <= 2) break;
                this.redstoneMode = 0;
                break;
            }
            case "empty": {
                this.leaveMaterialCount = 0;
                break;
            }
            case "leave": {
                this.leaveMaterialCount = 1;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterialCount > 0;
    }

    @Override
    public int getComparatorValue() {
        return this.getComparatorValueInternal();
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.isCreative = this.getUpgrades(EnumUpgrade.CREATIVE) > 0;
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    static List<ItemEntity> getNeighborItems(TileEntity te, Direction dir) {
        AxisAlignedBB box = new AxisAlignedBB(te.func_174877_v()).func_72321_a((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
        return te.func_145831_w().func_175647_a(ItemEntity.class, box, EntityPredicates.field_94557_a);
    }
}

