/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerAdvancedAirCompressor;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAirCompressor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityAdvancedAirCompressor
extends TileEntityAirCompressor {
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);

    public TileEntityAdvancedAirCompressor() {
        super((TileEntityType)ModTileEntities.ADVANCED_AIR_COMPRESSOR.get(), 20.0f, 25.0f, 10000);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    @Override
    protected void onFuelBurn(int burnedFuel) {
        this.heatExchanger.addHeat((double)burnedFuel / 2.0);
    }

    @Override
    public int getBaseProduction() {
        return 50;
    }

    @Override
    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerAdvancedAirCompressor(i, playerInventory, this.func_174877_v());
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }
}

