/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.entity.projectile.EntityTumblingBlock;
import me.desht.pneumaticcraft.common.inventory.ContainerAirCannon;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoatItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MinecartItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityAirCannon
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl,
IGUIButtonSensitive,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.airCannon.button.highSignalAndAngle", (Object)"gui.tab.redstoneBehaviour.button.highSignal", (Object)"gui.tab.redstoneBehaviour.airCannon.button.highAndSpace");
    private final AirCannonStackHandler itemHandler = new AirCannonStackHandler(this);
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.itemHandler);
    @DescSynced
    @LazySynced
    public float rotationAngle;
    @DescSynced
    @LazySynced
    public float heightAngle;
    @GuiSynced
    public int forceMult = 100;
    @DescSynced
    private float targetRotationAngle;
    @DescSynced
    private float targetHeightAngle;
    @GuiSynced
    public boolean doneTurning = false;
    @GuiSynced
    public int gpsX;
    @GuiSynced
    public int gpsY;
    @GuiSynced
    public int gpsZ;
    @GuiSynced
    public boolean coordWithinReach;
    @GuiSynced
    private int redstoneMode;
    private int oldRangeUpgrades;
    private boolean externalControl;
    private boolean entityUpgradeInserted;
    private boolean dispenserUpgradeInserted;
    private final List<ItemEntity> trackedItems = new ArrayList<ItemEntity>();
    private Set<UUID> trackedItemIds;
    private BlockPos lastInsertingInventory;
    private Direction lastInsertingInventorySide;
    @GuiSynced
    public boolean insertingInventoryHasSpace = true;
    private boolean gpsSlotChanged = true;
    private FakePlayer fakePlayer = null;
    private static final int INVENTORY_SIZE = 2;
    private static final int CANNON_SLOT = 0;
    private static final int GPS_SLOT = 1;

    public TileEntityAirCannon() {
        super((TileEntityType)ModTileEntities.AIR_CANNON.get(), 5.0f, 7.0f, 2000, 4);
    }

    @Override
    public void func_73660_a() {
        boolean isEntityTrackerUpgradeInserted;
        int curRangeUpgrades;
        boolean destUpdateNeeded = false;
        if (this.gpsSlotChanged) {
            destUpdateNeeded = this.checkGPSSlot();
            this.gpsSlotChanged = false;
        }
        if ((curRangeUpgrades = Math.min(8, this.getUpgrades(EnumUpgrade.RANGE))) != this.oldRangeUpgrades) {
            this.oldRangeUpgrades = curRangeUpgrades;
            if (!this.externalControl) {
                destUpdateNeeded = true;
            }
        }
        boolean isDispenserUpgradeInserted = this.getUpgrades(EnumUpgrade.DISPENSER) > 0;
        boolean bl = isEntityTrackerUpgradeInserted = this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) > 0;
        if (this.dispenserUpgradeInserted != isDispenserUpgradeInserted || this.entityUpgradeInserted != isEntityTrackerUpgradeInserted) {
            this.dispenserUpgradeInserted = isDispenserUpgradeInserted;
            this.entityUpgradeInserted = isEntityTrackerUpgradeInserted;
            destUpdateNeeded = true;
        }
        if (destUpdateNeeded) {
            this.updateDestination();
        }
        this.updateRotationAngles();
        if (!this.field_145850_b.field_72995_K) {
            this.updateTrackedItems();
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.isLeaking()) {
            this.airHandler.airLeak(this, this.getRotation());
        }
    }

    private boolean checkGPSSlot() {
        List<BlockPos> posList;
        ItemStack gpsStack = this.itemHandler.getStackInSlot(1);
        if (gpsStack.func_77973_b() instanceof IPositionProvider && !this.externalControl && !(posList = ((IPositionProvider)gpsStack.func_77973_b()).getStoredPositions(this.field_145850_b, gpsStack)).isEmpty() && posList.get(0) != null) {
            int destinationX = posList.get(0).func_177958_n();
            int destinationY = posList.get(0).func_177956_o();
            int destinationZ = posList.get(0).func_177952_p();
            if (destinationX != this.gpsX || destinationY != this.gpsY || destinationZ != this.gpsZ) {
                this.gpsX = destinationX;
                this.gpsY = destinationY;
                this.gpsZ = destinationZ;
                return true;
            }
        }
        return false;
    }

    private void updateRotationAngles() {
        this.doneTurning = true;
        float speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        if (this.rotationAngle < this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle < this.targetRotationAngle - 20.0f ? (this.rotationAngle += 3.0f * speedMultiplier) : (this.rotationAngle += 0.5f * speedMultiplier);
            if (this.rotationAngle > this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.rotationAngle > this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle > this.targetRotationAngle + 20.0f ? (this.rotationAngle -= 3.0f * speedMultiplier) : (this.rotationAngle -= 0.5f * speedMultiplier);
            if (this.rotationAngle < this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle < this.targetHeightAngle) {
            this.heightAngle = this.heightAngle < this.targetHeightAngle - 20.0f ? (this.heightAngle += 3.0f * speedMultiplier) : (this.heightAngle += 0.5f * speedMultiplier);
            if (this.heightAngle > this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle > this.targetHeightAngle) {
            this.heightAngle = this.heightAngle > this.targetHeightAngle + 20.0f ? (this.heightAngle -= 3.0f * speedMultiplier) : (this.heightAngle -= 0.5f * speedMultiplier);
            if (this.heightAngle < this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
    }

    private void updateTrackedItems() {
        if (this.trackedItemIds != null) {
            this.trackedItems.clear();
            ((ServerWorld)this.field_145850_b).getEntities().filter(entity -> this.trackedItemIds.contains(entity.func_110124_au()) && entity instanceof ItemEntity).map(entity -> (ItemEntity)entity).forEach(this.trackedItems::add);
            this.trackedItemIds = null;
        }
        Iterator<ItemEntity> iterator = this.trackedItems.iterator();
        block0: while (iterator.hasNext()) {
            ItemEntity item = iterator.next();
            if (item.field_70170_p != this.func_145831_w() || !item.func_70089_S()) {
                iterator.remove();
                continue;
            }
            HashMap<BlockPos, Direction> positions = new HashMap<BlockPos, Direction>();
            double range = 0.2;
            for (Direction d : Direction.values()) {
                double posX = item.field_70165_t + (double)d.func_82601_c() * range;
                double posY = item.field_70163_u + (double)d.func_96559_d() * range;
                double posZ = item.field_70161_v + (double)d.func_82599_e() * range;
                positions.put(new BlockPos((int)Math.floor(posX), (int)Math.floor(posY), (int)Math.floor(posZ)), d.func_176734_d());
            }
            for (Map.Entry entry : positions.entrySet()) {
                boolean inserted;
                BlockPos pos = (BlockPos)entry.getKey();
                TileEntity te = this.func_145831_w().func_175625_s(pos);
                if (te == null || !(inserted = ((Boolean)IOHelper.getInventoryForTE(te, (Direction)entry.getValue()).map(inv -> {
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)item.func_92059_d(), (boolean)false);
                    if (!remainder.func_190926_b()) {
                        item.func_92058_a(remainder);
                        this.insertingInventoryHasSpace = false;
                        return false;
                    }
                    item.func_70106_y();
                    iterator.remove();
                    this.lastInsertingInventory = te.func_174877_v();
                    this.lastInsertingInventorySide = (Direction)entry.getValue();
                    this.field_145850_b.func_184133_a(null, te.func_174877_v(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }).orElse((Object)false)).booleanValue())) continue;
                continue block0;
            }
        }
    }

    private void updateDestination() {
        this.doneTurning = false;
        double payloadFrictionY = 0.98;
        double payloadFrictionX = 0.98;
        double payloadGravity = 0.04;
        if (this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) > 0) {
            payloadFrictionX = 0.91;
            payloadGravity = 0.08;
        } else if (this.getUpgrades(EnumUpgrade.DISPENSER) > 0 && !this.itemHandler.getStackInSlot(0).func_190926_b()) {
            Item item = this.itemHandler.getStackInSlot(0).func_77973_b();
            if (item == Items.field_151068_bn || item == Items.field_151062_by || item == Items.field_151110_aK || item == Items.field_151126_ay) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.03;
            } else if (item == Items.field_151032_g) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.05;
            } else if (item == Items.field_151143_au || item == Items.field_151108_aI || item == Items.field_151140_bW || item == Items.field_151142_bV || item == Items.field_151109_aJ) {
                payloadFrictionY = 0.95;
            } else if (item == Items.field_151059_bz) {
                payloadGravity = 0.0;
            }
            if (item == Items.field_151068_bn) {
                payloadGravity = 0.05;
            } else if (item == Items.field_151062_by) {
                payloadGravity = 0.07;
            }
            payloadFrictionX = payloadFrictionY;
            if (item instanceof BoatItem) {
                payloadFrictionX = 0.99;
                payloadFrictionY = 0.95;
            }
            if (item instanceof SpawnEggItem) {
                payloadFrictionY = 0.98;
                payloadFrictionX = 0.91;
                payloadGravity = 0.08;
            }
        }
        double deltaX = this.gpsX - this.func_174877_v().func_177958_n();
        double deltaZ = this.gpsZ - this.func_174877_v().func_177952_p();
        float calculatedRotationAngle = deltaX >= 0.0 && deltaZ < 0.0 ? (float)(Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0) : (deltaX >= 0.0 && deltaZ >= 0.0 ? (float)(Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0) + 90.0f : (deltaX < 0.0 && deltaZ >= 0.0 ? (float)(Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0) + 180.0f : (float)(Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0) + 270.0f));
        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double deltaY = this.gpsY - this.func_174877_v().func_177956_o();
        float calculatedHeightAngle = this.calculateBestHeightAngle(distance, deltaY, this.getForce(), payloadGravity, payloadFrictionX, payloadFrictionY);
        this.setTargetAngles(calculatedRotationAngle, calculatedHeightAngle);
    }

    private float calculateBestHeightAngle(double distance, double deltaY, float force, double payloadGravity, double payloadFrictionX, double payloadFrictionY) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (payloadGravity == 0.0) {
            return 90.0f - (float)(Math.atan(deltaY / distance) * 180.0 / Math.PI);
        }
        for (double i = 0.031415926535897934; i < 1.5707963267948966; i += 0.01) {
            double motionX = MathHelper.func_76134_b((float)((float)i)) * force;
            double posX = 0.0;
            double posY = 0.0;
            for (double motionY = (double)(MathHelper.func_76126_a((float)((float)i)) * force); posY > deltaY || motionY > 0.0; motionY *= payloadFrictionY) {
                posX += motionX;
                posY += motionY;
                motionY -= payloadGravity;
                motionX *= payloadFrictionX;
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        this.coordWithinReach = bestDistance < 1.5;
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    private synchronized void setTargetAngles(float rotationAngle, float heightAngle) {
        this.targetRotationAngle = rotationAngle;
        this.targetHeightAngle = heightAngle;
        if (!this.func_145831_w().field_72995_K) {
            this.scheduleDescriptionPacket();
        }
    }

    private double[] getVelocityVector(float angleX, float angleZ, float force) {
        double[] velocities = new double[]{MathHelper.func_76126_a((float)(angleZ / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(angleX / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(angleZ / 180.0f * (float)Math.PI)) * -1.0f};
        velocities[0] = velocities[0] * (double)MathHelper.func_76126_a((float)(angleX / 180.0f * (float)Math.PI));
        velocities[2] = velocities[2] * (double)MathHelper.func_76126_a((float)(angleX / 180.0f * (float)Math.PI));
        double vectorTotal = velocities[0] * velocities[0] + velocities[1] * velocities[1] + velocities[2] * velocities[2];
        vectorTotal = (double)force / vectorTotal;
        int i = 0;
        while (i < 3) {
            int n = i++;
            velocities[n] = velocities[n] * vectorTotal;
        }
        return velocities;
    }

    public boolean hasCoordinate() {
        return this.gpsX != 0 || this.gpsY != 0 || this.gpsZ != 0;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    public float getForce() {
        return (0.5f + (float)this.oldRangeUpgrades / 2.0f) * (float)this.forceMult / 100.0f;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.targetRotationAngle = tag.func_74760_g("targetRotationAngle");
        this.targetHeightAngle = tag.func_74760_g("targetHeightAngle");
        this.rotationAngle = tag.func_74760_g("rotationAngle");
        this.heightAngle = tag.func_74760_g("heightAngle");
        this.gpsX = tag.func_74762_e("gpsX");
        this.gpsY = tag.func_74762_e("gpsY");
        this.gpsZ = tag.func_74762_e("gpsZ");
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.coordWithinReach = tag.func_74767_n("targetWithinReach");
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.forceMult = tag.func_74762_e("forceMult");
        this.trackedItemIds = new HashSet<UUID>();
        ListNBT tagList = tag.func_150295_c("trackedItems", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT t = tagList.func_150305_b(i);
            this.trackedItemIds.add(new UUID(t.func_74763_f("UUIDMost"), t.func_74763_f("UUIDLeast")));
        }
        if (tag.func_74764_b("inventoryX")) {
            this.lastInsertingInventory = new BlockPos(tag.func_74762_e("inventoryX"), tag.func_74762_e("inventoryY"), tag.func_74762_e("inventoryZ"));
            this.lastInsertingInventorySide = Direction.func_82600_a((int)tag.func_74771_c("inventorySide"));
        } else {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("targetRotationAngle", this.targetRotationAngle);
        tag.func_74776_a("targetHeightAngle", this.targetHeightAngle);
        tag.func_74776_a("rotationAngle", this.rotationAngle);
        tag.func_74776_a("heightAngle", this.heightAngle);
        tag.func_74768_a("gpsX", this.gpsX);
        tag.func_74768_a("gpsY", this.gpsY);
        tag.func_74768_a("gpsZ", this.gpsZ);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74757_a("targetWithinReach", this.coordWithinReach);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        tag.func_74768_a("forceMult", this.forceMult);
        ListNBT tagList = new ListNBT();
        for (ItemEntity entity : this.trackedItems) {
            UUID uuid = entity.func_110124_au();
            CompoundNBT t = new CompoundNBT();
            t.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
            t.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
            tagList.add((Object)t);
        }
        tag.func_218657_a("trackedItems", (INBT)tagList);
        if (this.lastInsertingInventory != null) {
            tag.func_74768_a("inventoryX", this.lastInsertingInventory.func_177958_n());
            tag.func_74768_a("inventoryY", this.lastInsertingInventory.func_177956_o());
            tag.func_74768_a("inventoryZ", this.lastInsertingInventory.func_177952_p());
            tag.func_74774_a("inventorySide", (byte)this.lastInsertingInventorySide.ordinal());
        }
        return tag;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerAirCannon(i, playerInventory, this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        int oldForceMult = this.forceMult;
        switch (tag) {
            case "redstone": {
                if (++this.redstoneMode > 2) {
                    this.redstoneMode = 0;
                }
                if (this.redstoneMode != 2 || this.getUpgrades(EnumUpgrade.BLOCK_TRACKER) != 0) break;
                this.redstoneMode = 0;
                break;
            }
            case "--": {
                this.forceMult = Math.max(this.forceMult - 10, 0);
                break;
            }
            case "-": {
                this.forceMult = Math.max(this.forceMult - 1, 0);
                break;
            }
            case "+": {
                this.forceMult = Math.min(this.forceMult + 1, 100);
                break;
            }
            case "++": {
                this.forceMult = Math.min(this.forceMult + 10, 100);
            }
        }
        if (this.forceMult != oldForceMult) {
            this.updateDestination();
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        boolean isPowered;
        boolean wasPowered = this.poweredRedstone > 0;
        super.onNeighborBlockUpdate();
        boolean bl = isPowered = this.poweredRedstone > 0;
        if (isPowered && !wasPowered && (this.redstoneMode != 0 || this.doneTurning) && (this.redstoneMode != 2 || this.inventoryCanCarry())) {
            this.fire();
        }
    }

    private boolean inventoryCanCarry() {
        this.insertingInventoryHasSpace = true;
        if (this.lastInsertingInventory == null) {
            return true;
        }
        if (this.itemHandler.getStackInSlot(0).func_190926_b()) {
            return true;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.lastInsertingInventory);
        return (Boolean)IOHelper.getInventoryForTE(te, this.lastInsertingInventorySide).map(inv -> {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)this.itemHandler.getStackInSlot(0).func_77946_l(), (boolean)true);
            this.insertingInventoryHasSpace = remainder.func_190926_b();
            return this.insertingInventoryHasSpace;
        }).orElseGet(() -> {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
            return true;
        });
    }

    private synchronized boolean fire() {
        Entity launchedEntity = this.getCloseEntityIfUpgraded();
        if (this.getPressure() >= 2.0f && (launchedEntity != null || !this.itemHandler.getStackInSlot(0).func_190926_b())) {
            float force = this.getForce();
            double[] velocity = this.getVelocityVector(this.heightAngle, this.rotationAngle, force);
            this.addAir((int)(-500.0f * force));
            boolean shootingInventory = false;
            if (launchedEntity == null) {
                shootingInventory = true;
                launchedEntity = this.getPayloadEntity();
                if (launchedEntity instanceof ItemEntity) {
                    this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    if (this.getUpgrades(EnumUpgrade.BLOCK_TRACKER) > 0) {
                        this.trackedItems.add((ItemEntity)launchedEntity);
                    }
                    ((ItemEntity)launchedEntity).func_174867_a(20);
                } else {
                    this.itemHandler.extractItem(0, 1, false);
                }
            } else if (launchedEntity instanceof PlayerEntity) {
                ServerPlayerEntity entityplayermp = (ServerPlayerEntity)launchedEntity;
                if (entityplayermp.field_71135_a.func_147298_b().func_150724_d()) {
                    entityplayermp.field_184851_cj = true;
                    entityplayermp.func_70634_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.8, (double)this.func_174877_v().func_177952_p() + 0.5);
                }
            }
            TileEntityAirCannon.launchEntity(launchedEntity, new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.8, (double)this.func_174877_v().func_177952_p() + 0.5), new Vec3d(velocity[0], velocity[1], velocity[2]), shootingInventory);
            return true;
        }
        return false;
    }

    private Entity getPayloadEntity() {
        Entity e = TileEntityAirCannon.getEntityToLaunch(this.func_145831_w(), this.itemHandler.getStackInSlot(0), this.getFakePlayer(), this.getUpgrades(EnumUpgrade.DISPENSER) > 0, false);
        if (e instanceof ItemEntity) {
            ((ItemEntity)e).func_70288_d();
            ((ItemEntity)e).lifespan += Math.min(this.getUpgrades(EnumUpgrade.ITEM_LIFE) * 600, 4800);
        }
        return e;
    }

    private PlayerEntity getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.func_145831_w()), (GameProfile)new GameProfile(null, "[Air Cannon]"));
            this.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)this.fakePlayer);
            this.fakePlayer.field_70165_t = (double)this.func_174877_v().func_177958_n() + 0.5;
            this.fakePlayer.field_70163_u = (double)this.func_174877_v().func_177956_o() + 0.5;
            this.fakePlayer.field_70161_v = (double)this.func_174877_v().func_177952_p() + 0.5;
        }
        return this.fakePlayer;
    }

    public static void launchEntity(Entity launchedEntity, Vec3d initialPos, Vec3d velocity, boolean doSpawn) {
        World world = launchedEntity.func_130014_f_();
        if (launchedEntity.func_184187_bx() != null) {
            launchedEntity.func_184210_p();
        }
        launchedEntity.func_70107_b(initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c);
        NetworkHandler.sendToAllAround((Object)new PacketSetEntityMotion(launchedEntity, velocity), new PacketDistributor.TargetPoint(initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c, 64.0, world.func_201675_m().func_186058_p()));
        if (launchedEntity instanceof FireballEntity) {
            FireballEntity fireball = (FireballEntity)launchedEntity;
            fireball.field_70232_b = velocity.field_72450_a * 0.05;
            fireball.field_70233_c = velocity.field_72448_b * 0.05;
            fireball.field_70230_d = velocity.field_72449_c * 0.05;
        } else {
            launchedEntity.func_213317_d(velocity);
        }
        launchedEntity.field_70122_E = false;
        launchedEntity.field_70132_H = false;
        launchedEntity.field_70123_F = false;
        launchedEntity.field_70124_G = false;
        if (doSpawn && !world.field_72995_K) {
            world.func_217376_c(launchedEntity);
        }
        for (int i = 0; i < 5; ++i) {
            double velX = velocity.field_72450_a * 0.4 + (world.field_73012_v.nextGaussian() - 0.5) * 0.05;
            double velY = velocity.field_72448_b * 0.4 + (world.field_73012_v.nextGaussian() - 0.5) * 0.05;
            double velZ = velocity.field_72449_c * 0.4 + (world.field_73012_v.nextGaussian() - 0.5) * 0.05;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c, velX, velY, velZ), world);
        }
        NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.AIR_CANNON.get(), SoundCategory.BLOCKS, initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c, 1.0f, world.field_73012_v.nextFloat() / 4.0f + 0.75f, true), world);
    }

    public static Entity getEntityToLaunch(World world, ItemStack stack, PlayerEntity player, boolean hasDispenser, boolean fallingBlocks) {
        Item item = stack.func_77973_b();
        if (hasDispenser) {
            if (item == Blocks.field_150335_W.func_199767_j()) {
                TNTEntity tnt = new TNTEntity(world, 0.0, 0.0, 0.0, (LivingEntity)player);
                tnt.func_184534_a(80);
                return tnt;
            }
            if (item == Items.field_151062_by) {
                return new ExperienceBottleEntity(world, (LivingEntity)player);
            }
            if (item instanceof PotionItem) {
                PotionEntity potionEntity = new PotionEntity(world, (LivingEntity)player);
                potionEntity.func_184541_a(stack);
                return potionEntity;
            }
            if (item instanceof ArrowItem) {
                return ((ArrowItem)item).func_200887_a(world, stack, (LivingEntity)player);
            }
            if (item == Items.field_151110_aK) {
                return new EggEntity(world, (LivingEntity)player);
            }
            if (item == Items.field_151059_bz) {
                return new SmallFireballEntity(world, (LivingEntity)player, 0.0, 0.0, 0.0);
            }
            if (item == Items.field_151126_ay) {
                return new SnowballEntity(world, (LivingEntity)player);
            }
            if (item instanceof SpawnEggItem) {
                EntityType type = ((SpawnEggItem)item).func_208076_b(stack.func_77978_p());
                Entity e = type.func_220331_a(world, stack, player, player.func_180425_c(), SpawnReason.SPAWN_EGG, false, false);
                if (e instanceof LivingEntity && stack.func_82837_s()) {
                    e.func_200203_b(stack.func_200301_q());
                }
                return e;
            }
            if (item instanceof MinecartItem) {
                return MinecartEntity.func_184263_a((World)world, (double)0.0, (double)0.0, (double)0.0, (AbstractMinecartEntity.Type)((MinecartItem)item).field_77841_a);
            }
            if (item instanceof BoatItem) {
                return new BoatEntity(world, 0.0, 0.0, 0.0);
            }
            if (item == Items.field_196152_dE) {
                return new FireworkRocketEntity(world, 0.0, 0.0, 0.0, stack);
            }
        }
        if (fallingBlocks && item instanceof BlockItem) {
            return new EntityTumblingBlock(world, (LivingEntity)player, 0.0, 0.0, 0.0, stack);
        }
        ItemEntity e = new ItemEntity(world, 0.0, 0.0, 0.0, stack);
        e.func_174867_a(20);
        return e;
    }

    private Entity getCloseEntityIfUpgraded() {
        int entityUpgrades = this.getUpgrades(EnumUpgrade.ENTITY_TRACKER);
        if (entityUpgrades > 0) {
            entityUpgrades = Math.min(entityUpgrades, 5);
            List entities = this.func_145831_w().func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_174877_v().func_177982_a(-entityUpgrades, -entityUpgrades, -entityUpgrades), this.func_174877_v().func_177982_a(1 + entityUpgrades, 1 + entityUpgrades, 1 + entityUpgrades)));
            if (entities.isEmpty()) {
                return null;
            }
            Entity closest = (Entity)entities.get(0);
            Vec3d pos = PneumaticCraftUtils.getBlockCentre(this.func_174877_v());
            for (Entity entity : entities) {
                double d2;
                double d1 = PneumaticCraftUtils.distBetweenSq(closest.field_70165_t, closest.field_70163_u, closest.field_70161_v, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                if (!(d1 > (d2 = PneumaticCraftUtils.distBetweenSq(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c)))) continue;
                closest = entity;
            }
            return closest;
        }
        return null;
    }

    @Override
    protected void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setTargetLocation"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "x, y, z");
                TileEntityAirCannon.this.gpsX = ((Double)args[0]).intValue();
                TileEntityAirCannon.this.gpsY = ((Double)args[1]).intValue();
                TileEntityAirCannon.this.gpsZ = ((Double)args[2]).intValue();
                TileEntityAirCannon.this.updateDestination();
                return new Object[]{TileEntityAirCannon.this.coordWithinReach};
            }
        });
        registry.registerLuaMethod(new LuaMethod("fire"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityAirCannon.this.fire()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("isDoneTurning"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityAirCannon.this.doneTurning};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRotationAngle"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "angle (in degrees, 0 = north)");
                TileEntityAirCannon.this.setTargetAngles(((Double)args[0]).floatValue(), TileEntityAirCannon.this.targetHeightAngle);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setHeightAngle"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "angle (in degrees, 0 = horizontal)");
                TileEntityAirCannon.this.setTargetAngles(TileEntityAirCannon.this.targetRotationAngle, 90.0f - ((Double)args[0]).floatValue());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                TileEntityAirCannon.this.externalControl = (Boolean)args[0];
                return null;
            }
        });
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventory;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    public String getRedstoneTabTitle() {
        return "gui.tab.redstoneBehaviour.airCannon.fireUpon";
    }

    private class AirCannonStackHandler
    extends BaseItemStackHandler {
        AirCannonStackHandler(TileEntity te) {
            super(te, 2);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (slot == 1) {
                return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof IPositionProvider;
            }
            return true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1) {
                TileEntityAirCannon.this.gpsSlotChanged = true;
            }
        }
    }
}

