/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.BlockChargingStation;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStation;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.inventory.handler.ChargeableItemHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class TileEntityChargingStation
extends TileEntityPneumaticBase
implements IRedstoneControl,
ICamouflageableTE,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.doneDischarging", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.charging", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.discharging");
    private static final int INVENTORY_SIZE = 1;
    public static final int CHARGE_INVENTORY_INDEX = 0;
    @DescSynced
    private ItemStack chargingStackSynced = ItemStack.field_190927_a;
    public ItemEntity chargingStackEntity;
    private ChargingStationHandler itemHandler;
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    private ChargeableItemHandler chargeableInventory;
    @GuiSynced
    public float chargingItemPressure;
    @GuiSynced
    public boolean charging;
    @GuiSynced
    public boolean discharging;
    @GuiSynced
    public int redstoneMode;
    private boolean oldRedstoneStatus;
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState;

    public TileEntityChargingStation() {
        super((TileEntityType)ModTileEntities.CHARGING_STATION.get(), 20.0f, 25.0f, 1000, 4);
        this.itemHandler = new ChargingStationHandler();
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        this.chargingStackEntity = new ItemEntity(EntityType.field_200765_E, this.field_145850_b);
        this.chargingStackEntity.func_92058_a(this.chargingStackSynced);
        super.onDescUpdate();
    }

    @Nonnull
    public ItemStack getChargingStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            List<IAirHandlerMachine.Connection> teList;
            this.discharging = false;
            this.charging = false;
            this.chargingStackSynced = this.itemHandler.getStackInSlot(0);
            int airToTransfer = (int)(10.0f * this.getSpeedMultiplierFromUpgrades());
            for (IAirHandler itemAirHandler : this.findChargeable()) {
                float itemPressure = itemAirHandler.getPressure();
                float itemVolume = itemAirHandler.getVolume();
                float delta = Math.abs(this.getPressure() - itemPressure) / 2.0f;
                int airInItem = (int)(itemPressure * itemVolume);
                if (itemPressure > this.getPressure() + 0.01f && itemPressure > 0.0f) {
                    int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)this.airHandler.getVolume()));
                    itemAirHandler.addAir(-airToMove);
                    this.addAir(airToMove);
                    this.discharging = true;
                    continue;
                }
                if (!(itemPressure < this.getPressure() - 0.01f) || !(itemPressure < itemAirHandler.maxPressure())) continue;
                int maxAirInItem = (int)(itemAirHandler.maxPressure() * itemVolume);
                int airToMove = Math.min(Math.min(airToTransfer, this.airHandler.getAir()), maxAirInItem - airInItem);
                airToMove = Math.min((int)(delta * itemVolume), airToMove);
                itemAirHandler.addAir(airToMove);
                this.addAir(-airToMove);
                this.charging = true;
            }
            if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
                this.oldRedstoneStatus = this.shouldEmitRedstone();
                this.updateNeighbours();
            }
            if ((teList = this.airHandler.getConnectedAirHandlers(this)).isEmpty()) {
                this.airHandler.airLeak(this, this.getRotation());
            }
        }
    }

    private List<IAirHandler> findChargeable() {
        ArrayList<IAirHandler> res = new ArrayList<IAirHandler>();
        if (!this.getChargingStack().func_190926_b()) {
            this.getChargingStack().getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
                res.add((IAirHandler)h);
                this.chargingItemPressure = h.getPressure();
            });
        }
        if (this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            List entitiesOnPad = this.func_145831_w().func_217357_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()));
            for (Entity entity : entitiesOnPad) {
                if (entity instanceof ItemEntity) {
                    ((ItemEntity)entity).func_92059_d().getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(res::add);
                    continue;
                }
                if (entity instanceof PlayerEntity) {
                    PlayerInventory inv = ((PlayerEntity)entity).field_71071_by;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(res::add);
                    }
                    continue;
                }
                entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(res::add);
            }
        }
        return res;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        switch (tag) {
            case "redstone": {
                ++this.redstoneMode;
                if (this.redstoneMode > 3) {
                    this.redstoneMode = 0;
                }
                this.updateNeighbours();
                break;
            }
            case "open_upgrades": {
                INamedContainerProvider provider = ((IChargeableContainerProvider)this.getChargingStack().func_77973_b()).getContainerProvider(this);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (BlockPos)this.func_174877_v());
                break;
            }
            case "close_upgrades": {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return !this.charging && !this.discharging && this.getChargingStack().getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).isPresent();
            }
            case 2: {
                return this.charging;
            }
            case 3: {
                return this.discharging;
            }
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public ChargeableItemHandler getChargeableInventory() {
        return this.func_145831_w().field_72995_K ? new ChargeableItemHandler(this) : this.chargeableInventory;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.itemHandler = new ChargingStationHandler();
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        ItemStack chargeSlot = this.getChargingStack();
        if (chargeSlot.func_77973_b() instanceof IChargeableContainerProvider) {
            this.chargeableInventory = new ChargeableItemHandler(this);
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)BlockChargingStation.CHARGE_PAD, (Comparable)Boolean.valueOf(this.getUpgrades(EnumUpgrade.DISPENSER) > 0)));
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().chargingStations.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().chargingStations.add(this);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerChargingStation(i, playerInventory, this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    private class ChargingStationHandler
    extends BaseItemStackHandler {
        ChargingStationHandler() {
            super(TileEntityChargingStation.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.func_190926_b() || itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).isPresent());
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileEntityChargingStation teCS = TileEntityChargingStation.this;
            ItemStack newStack = this.getStackInSlot(slot);
            if (!ItemStack.func_179545_c((ItemStack)TileEntityChargingStation.this.chargingStackSynced, (ItemStack)newStack)) {
                TileEntityChargingStation.this.chargingStackSynced = new ItemStack((IItemProvider)newStack.func_77973_b());
            }
            if (teCS.func_145831_w().field_72995_K || slot != 0) {
                return;
            }
            teCS.chargeableInventory = newStack.func_77973_b() instanceof IChargeableContainerProvider ? new ChargeableItemHandler(teCS) : null;
            for (PlayerEntity player : teCS.func_145831_w().func_217369_A()) {
                if (!(player instanceof ServerPlayerEntity) || !(player.field_71070_bA instanceof ContainerChargingStationItemInventory) || ((ContainerChargingStationItemInventory)player.field_71070_bA).te != this.te) continue;
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)TileEntityChargingStation.this, (BlockPos)TileEntityChargingStation.this.func_174877_v());
            }
        }
    }
}

