/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityPressureTube
extends TileEntityPneumaticBase
implements IAirListener,
IManoMeasurable,
ICamouflageableTE {
    @DescSynced
    public final boolean[] sidesClosed = new boolean[6];
    public TubeModule[] modules = new TubeModule[6];
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState;
    private AxisAlignedBB renderBoundingBox = null;
    private Direction inLineModuleDir = null;

    public TileEntityPressureTube() {
        this((TileEntityType)ModTileEntities.PRESSURE_TUBE.get(), 5.0f, 7.0f, 1000, 0);
    }

    TileEntityPressureTube(TileEntityType type, float dangerPressurePressureTube, float maxPressurePressureTube, int volumePressureTube, int upgradeSlots) {
        super(type, dangerPressurePressureTube, maxPressurePressureTube, volumePressureTube, upgradeSlots);
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        byte closed = nbt.func_74771_c("sidesClosed");
        for (int i = 0; i < 6; ++i) {
            this.sidesClosed[i] = (closed & 1 << i) != 0;
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(nbt);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        byte connected = 0;
        byte closed = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.sidesClosed[i]) continue;
            closed = (byte)(closed | 1 << i);
        }
        nbt.func_74774_a("sidesConnected", connected);
        nbt.func_74774_a("sidesClosed", closed);
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, nbt);
        return nbt;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        this.writeModulesToNBT(tag);
    }

    public void writeModulesToNBT(CompoundNBT tag) {
        ListNBT moduleList = new ListNBT();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            CompoundNBT moduleTag = new CompoundNBT();
            moduleTag.func_74778_a("type", this.modules[i].getType().toString());
            this.modules[i].writeToNBT(moduleTag);
            moduleTag.func_74768_a("side", i);
            moduleList.add((Object)moduleTag);
        }
        tag.func_218657_a("modules", (INBT)moduleList);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.modules = new TubeModule[6];
        ListNBT moduleList = tag.func_150295_c("modules", 10);
        for (int i = 0; i < moduleList.size(); ++i) {
            CompoundNBT moduleTag = moduleList.func_150305_b(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(moduleTag.func_74779_i("type")));
            if (item instanceof ItemTubeModule) {
                TubeModule module = ((ItemTubeModule)item).createModule();
                if (module == null) continue;
                module.readFromNBT(moduleTag);
                this.setModule(module, Direction.func_82600_a((int)moduleTag.func_74762_e("side")));
                continue;
            }
            Log.error("received unknown tube module ID from server: " + moduleTag.func_74779_i("type"), new Object[0]);
        }
        this.updateRenderBoundingBox();
        if (this.func_145830_o() && this.func_145831_w().field_72995_K) {
            this.rerenderTileEntity();
        }
    }

    private void updateRenderBoundingBox() {
        this.renderBoundingBox = new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
        for (int i = 0; i < 6; ++i) {
            if (this.modules[i] == null || this.modules[i].getRenderBoundingBox() == null) continue;
            this.renderBoundingBox = this.renderBoundingBox.func_111270_a(this.modules[i].getRenderBoundingBox());
        }
    }

    @Override
    public void func_73660_a() {
        IAirHandlerMachine.Connection c;
        Direction d;
        List<IAirHandlerMachine.Connection> l;
        super.func_73660_a();
        boolean hasModules = false;
        boolean hasClosedSide = false;
        for (Direction dir : Direction.field_199792_n) {
            if (this.modules[dir.func_176745_a()] != null) {
                hasModules = true;
                this.modules[dir.func_176745_a()].shouldDrop = true;
                this.modules[dir.func_176745_a()].update();
            }
            if (!this.sidesClosed[dir.func_176745_a()]) continue;
            hasClosedSide = true;
        }
        if (!this.func_145831_w().field_72995_K && !hasModules && !hasClosedSide && (l = this.airHandler.getConnectedAirHandlers(this)).size() == 1 && (d = (c = l.get(0)).getDirection()) != null && this.modules[d.func_176734_d().ordinal()] == null && this.canConnectPneumatic(d.func_176734_d())) {
            this.airHandler.airLeak(this, d.func_176734_d());
        }
    }

    @Override
    public void onAirDispersion(IAirHandlerMachine handler, @Nullable Direction side, int airDispersed) {
        int intSide;
        if (side != null && this.modules[intSide = side.ordinal()] instanceof IInfluenceDispersing) {
            ((IInfluenceDispersing)((Object)this.modules[intSide])).onAirDispersion(airDispersed);
        }
    }

    @Override
    public int getMaxDispersion(IAirHandlerMachine handler, @Nullable Direction side) {
        int intSide;
        if (side != null && this.modules[intSide = side.ordinal()] instanceof IInfluenceDispersing) {
            return ((IInfluenceDispersing)((Object)this.modules[intSide])).getMaxDispersion();
        }
        return Integer.MAX_VALUE;
    }

    public TubeModule getModule(Direction side) {
        return this.modules[side.func_176745_a()];
    }

    public boolean mayPlaceModule(Direction side) {
        return this.inLineModuleDir == null && this.modules[side.ordinal()] == null && !this.sidesClosed[side.ordinal()];
    }

    public void setModule(TubeModule module, Direction side) {
        if (module != null) {
            module.setDirection(side);
            module.setTube(this);
            if (module.isInline()) {
                this.inLineModuleDir = side;
            }
        } else if (this.inLineModuleDir == side) {
            this.inLineModuleDir = null;
        }
        this.modules[side.func_176745_a()] = module;
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), BlockPressureTube.recalculateState((IWorld)this.field_145850_b, this.field_174879_c, this.func_195044_w()), 3);
            this.sendDescriptionPacket();
            this.func_70296_d();
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return !(this.inLineModuleDir != null && this.inLineModuleDir.func_176740_k() != side.func_176740_k() || this.sidesClosed[side.ordinal()] || this.modules[side.ordinal()] != null && !this.modules[side.ordinal()].isInline());
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.onNeighborTileUpdate();
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.onNeighborBlockUpdate();
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public TileEntity getConnectedNeighbor(Direction dir) {
        TileEntity te;
        int idx = dir.func_176745_a();
        if (!this.sidesClosed[idx] && (this.modules[idx] == null || this.modules[idx].isInline() && dir.func_176740_k() == this.modules[idx].getDirection().func_176740_k()) && (te = this.getCachedNeighbor(dir)) != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.func_176734_d()).isPresent()) {
            return te;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox != null ? this.renderBoundingBox : new AxisAlignedBB(this.func_174877_v());
    }

    @Override
    public void printManometerMessage(PlayerEntity player, List<ITextComponent> text) {
        Direction dir;
        RayTraceResult mop = PneumaticCraftUtils.getEntityLookedObject((LivingEntity)player);
        if (mop != null && mop.hitInfo instanceof Direction && this.modules[(dir = (Direction)mop.hitInfo).ordinal()] != null) {
            this.modules[dir.ordinal()].addInfo(text);
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
            this.func_70296_d();
        }
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        super.onDescUpdate();
    }

    public static TileEntityPressureTube getTube(TileEntity te) {
        return te instanceof TileEntityPressureTube ? (TileEntityPressureTube)te : null;
    }
}

