/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.render.RenderRangeLines;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationHacking;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationMain;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemNetworkComponent;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketRenderRangeLines;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRangeLineShower;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class TileEntitySecurityStation
extends TileEntityTickableBase
implements IGUITextFieldSensitive,
IRangeLineShower,
IRedstoneControl,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.securityStation.button.hacked", (Object)"gui.tab.redstoneBehaviour.securityStation.button.doneRebooting");
    public static final int INV_ROWS = 7;
    public static final int INV_COLS = 5;
    private static final int INVENTORY_SIZE = 35;
    private final SecurityStationHandler inventory = new SecurityStationHandler();
    private LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public final List<GameProfile> hackedUsers = new ArrayList<GameProfile>();
    public final List<GameProfile> sharedUsers = new ArrayList<GameProfile>();
    @GuiSynced
    private int rebootTimer;
    @GuiSynced
    private String textFieldText = "";
    private int securityRange;
    private int oldSecurityRange;
    private RenderRangeLines rangeLineRenderer;
    @GuiSynced
    public int redstoneMode;
    private boolean oldRedstoneStatus;
    private boolean validNetwork;

    public TileEntitySecurityStation() {
        super((TileEntityType)ModTileEntities.SECURITY_STATION.get(), 4);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().securityStations.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().securityStations.add(this);
        this.rangeLineRenderer = new RenderRangeLines(0x33FF0000, this.func_174877_v());
    }

    @Override
    public void func_73660_a() {
        if (this.rebootTimer > 0) {
            --this.rebootTimer;
            if (!this.func_145831_w().field_72995_K && this.rebootTimer == 0) {
                this.hackedUsers.clear();
            }
        }
        if (this.func_145831_w().field_72995_K && !this.firstRun) {
            if (this.oldSecurityRange != this.getSecurityRange() || this.oldSecurityRange == 0) {
                this.rangeLineRenderer.resetRendering(this.getSecurityRange());
                this.oldSecurityRange = this.getSecurityRange();
            }
            this.rangeLineRenderer.update();
        }
        if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours();
        }
        this.securityRange = Math.min(2 + this.getUpgrades(EnumUpgrade.RANGE), 16);
        super.func_73660_a();
    }

    public void rebootStation() {
        this.rebootTimer = 1200;
    }

    public int getRebootTime() {
        return this.rebootTimer;
    }

    @Override
    public void showRangeLines() {
        if (this.func_145831_w().field_72995_K) {
            this.rangeLineRenderer.resetRendering(this.getSecurityRange());
        } else {
            NetworkHandler.sendToAllAround(new PacketRenderRangeLines(this), this.func_145831_w(), 64.0 + (double)this.getSecurityRange());
        }
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderRangeLines() {
        this.rangeLineRenderer.render();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        } else if (tag.equals("reboot")) {
            this.rebootStation();
        } else if (tag.equals("test")) {
            if (!this.hasValidNetwork()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "This Security Station is out of order: Its network hasn't been properly configured.", new Object[0]), false);
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new HackingContainerProvider(), (BlockPos)this.func_174877_v());
            }
        } else if (tag.startsWith("remove:")) {
            try {
                int idx = Integer.parseInt(tag.split(":")[1]);
                this.sharedUsers.remove(idx);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
                // empty catch block
            }
        }
        this.sendDescriptionPacket();
    }

    public HackingContainerProvider getHackingContainerProvider() {
        return new HackingContainerProvider();
    }

    public void addSharedUser(GameProfile user) {
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.sharedUsers.add(user);
        this.sendDescriptionPacket();
    }

    public void addHacker(GameProfile user) {
        for (GameProfile hackedUser : this.hackedUsers) {
            if (!this.gameProfileEquals(hackedUser, user)) continue;
            return;
        }
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.hackedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private boolean gameProfileEquals(GameProfile profile1, GameProfile profile2) {
        return profile1.getId() != null && profile2.getId() != null ? profile1.getId().equals(profile2.getId()) : profile1.getName().equals(profile2.getName());
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isHacked();
            }
            case 2: {
                return this.getRebootTime() <= 0;
            }
        }
        return false;
    }

    public boolean isHacked() {
        return this.hackedUsers.size() > 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.rangeLineRenderer == null || !this.rangeLineRenderer.isCurrentlyRendering()) {
            return super.getRenderBoundingBox();
        }
        return this.getAffectedBoundingBox();
    }

    public AxisAlignedBB getAffectedBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)this.getSecurityRange());
    }

    public int getSecurityRange() {
        return this.securityRange;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.rebootTimer = tag.func_74762_e("startupTimer");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.checkForNetworkValidity();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("startupTimer", this.rebootTimer);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        ListNBT sharedList = new ListNBT();
        for (GameProfile sharedUser : this.sharedUsers) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74778_a("name", sharedUser.getName());
            if (sharedUser.getId() != null) {
                tagCompound.func_74778_a("uuid", sharedUser.getId().toString());
            }
            sharedList.add((Object)tagCompound);
        }
        tag.func_218657_a("SharedUsers", (INBT)sharedList);
        ListNBT hackedList = new ListNBT();
        for (GameProfile hackedUser : this.hackedUsers) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74778_a("name", hackedUser.getName());
            if (hackedUser.getId() != null) {
                tagCompound.func_74778_a("uuid", hackedUser.getId().toString());
            }
            hackedList.add((Object)tagCompound);
        }
        tag.func_218657_a("HackedUsers", (INBT)hackedList);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.sharedUsers.clear();
        ListNBT sharedList = tag.func_150295_c("SharedUsers", 10);
        for (int i = 0; i < sharedList.size(); ++i) {
            CompoundNBT tagCompound = sharedList.func_150305_b(i);
            this.sharedUsers.add(new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
        this.hackedUsers.clear();
        ListNBT hackedList = tag.func_150295_c("HackedUsers", 10);
        for (int i = 0; i < hackedList.size(); ++i) {
            CompoundNBT tagCompound = hackedList.func_150305_b(i);
            this.hackedUsers.add(new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.textFieldText = text;
    }

    @Override
    public String getText(int textFieldID) {
        return this.textFieldText;
    }

    public boolean doesAllowPlayer(PlayerEntity player) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(player) || this.hasPlayerHacked(player);
    }

    public boolean isPlayerOnWhiteList(PlayerEntity player) {
        for (int i = 0; i < this.sharedUsers.size(); ++i) {
            GameProfile user = this.sharedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.sharedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station shared username '" + player.func_200200_C_() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean hasPlayerHacked(PlayerEntity player) {
        for (int i = 0; i < this.hackedUsers.size(); ++i) {
            GameProfile user = this.hackedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.hackedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station hacked username '" + player.func_200200_C_() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean connects(int firstSlot, int secondSlot) {
        if (firstSlot < 0 || secondSlot < 0 || firstSlot >= 35 || secondSlot >= 35 || firstSlot == secondSlot || this.inventory.getStackInSlot(firstSlot).func_190926_b() || this.inventory.getStackInSlot(secondSlot).func_190926_b()) {
            return false;
        }
        for (int column = -1; column <= 1; ++column) {
            for (int row = -1; row <= 1; ++row) {
                if (firstSlot + row * 5 + column != secondSlot || !(firstSlot % 5 > 0 && firstSlot % 5 < 4 || secondSlot % 5 > 0 && secondSlot % 5 < 4) && secondSlot % 5 != firstSlot % 5) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidNetwork() {
        return this.validNetwork;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSecurityStationMain(i, playerInventory, this.func_174877_v());
    }

    public EnumNetworkValidityProblem checkForNetworkValidity() {
        this.validNetwork = false;
        int ioPortSlot = -1;
        int registrySlot = -1;
        int subroutineSlot = -1;
        block5: for (int i = 0; i < 35; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemNetworkComponent.NetworkComponentType type = ItemNetworkComponent.getType(this.inventory.getStackInSlot(i));
            assert (type != null);
            switch (type) {
                case DIAGNOSTIC_SUBROUTINE: {
                    if (subroutineSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_SUBROUTINES;
                    }
                    subroutineSlot = i;
                    continue block5;
                }
                case NETWORK_IO_PORT: {
                    if (ioPortSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_IO_PORTS;
                    }
                    ioPortSlot = i;
                    continue block5;
                }
                case NETWORK_REGISTRY: {
                    if (registrySlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_REGISTRIES;
                    }
                    registrySlot = i;
                }
            }
        }
        if (subroutineSlot == -1) {
            return EnumNetworkValidityProblem.NO_SUBROUTINE;
        }
        if (ioPortSlot == -1) {
            return EnumNetworkValidityProblem.NO_IO_PORT;
        }
        if (registrySlot == -1) {
            return EnumNetworkValidityProblem.NO_REGISTRY;
        }
        if (!this.traceComponent(subroutineSlot, ioPortSlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_SUB_AND_IO_PORT;
        }
        if (!this.traceComponent(ioPortSlot, registrySlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_IO_PORT_AND_REGISTRY;
        }
        this.validNetwork = true;
        return EnumNetworkValidityProblem.NONE;
    }

    private boolean traceComponent(int startSlot, int targetSlot, boolean[] slotsDone) {
        for (int i = 0; i < 35; ++i) {
            if (slotsDone[i] || !this.connects(startSlot, i)) continue;
            if (i == targetSlot) {
                return true;
            }
            slotsDone[i] = true;
            if (!this.traceComponent(i, targetSlot, slotsDone)) continue;
            return true;
        }
        return false;
    }

    public int getDetectionChance() {
        return Math.min(100, 20 + 20 * this.getUpgrades(EnumUpgrade.ENTITY_TRACKER));
    }

    public int getSecurityLevel() {
        return 1 + this.getUpgrades(EnumUpgrade.SECURITY);
    }

    @Override
    public boolean isGuiUseableByPlayer(PlayerEntity par1EntityPlayer) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    private class HackingContainerProvider
    implements INamedContainerProvider {
        private HackingContainerProvider() {
        }

        public ITextComponent func_145748_c_() {
            return TileEntitySecurityStation.this.getDisplayNameInternal().func_150258_a(" Hacking");
        }

        @Nullable
        public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new ContainerSecurityStationHacking(i, playerInventory, TileEntitySecurityStation.this.func_174877_v());
        }
    }

    private class SecurityStationHandler
    extends BaseItemStackHandler {
        private SecurityStationHandler() {
            super(TileEntitySecurityStation.this, 35);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySecurityStation.this.checkForNetworkValidity();
        }
    }

    public static enum EnumNetworkValidityProblem {
        NONE,
        NO_SUBROUTINE,
        NO_IO_PORT,
        NO_REGISTRY,
        TOO_MANY_SUBROUTINES,
        TOO_MANY_IO_PORTS,
        TOO_MANY_REGISTRIES,
        NO_CONNECTION_SUB_AND_IO_PORT,
        NO_CONNECTION_IO_PORT_AND_REGISTRY;

    }
}

