/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerTagWorkbench;
import me.desht.pneumaticcraft.common.item.ItemTagFilter;
import me.desht.pneumaticcraft.common.tileentity.TileEntityDisplayTable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityTagWorkbench
extends TileEntityDisplayTable
implements INamedContainerProvider {
    public static final int PAPER_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    private final TagMatcherItemHandler inventory = new TagMatcherItemHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public int paperItemId;
    public int outputItemId;

    public TileEntityTagWorkbench() {
        super((TileEntityType<?>)((TileEntityType)ModTileEntities.TAG_WORKBENCH.get()));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.startsWith("write:")) {
            String[] data = tag.substring(6).split(",");
            if (data.length == 0) {
                return;
            }
            ItemStack outputStack = ItemStack.field_190927_a;
            if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                outputStack = this.inventory.getStackInSlot(2);
            } else if (!this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.extractItem(1, 1, false);
                outputStack = new ItemStack((IItemProvider)ModItems.TAG_FILTER.get());
            }
            if (!outputStack.func_190926_b()) {
                Set<ResourceLocation> tags = ItemTagFilter.getConfiguredTagList(outputStack);
                for (String s : data) {
                    tags.add(new ResourceLocation(s));
                }
                ItemTagFilter.setConfiguredTagList(outputStack, tags);
                this.inventory.setStackInSlot(2, outputStack);
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.itemId = Item.func_150891_b((Item)this.inventory.getStackInSlot(0).func_77973_b());
        this.paperItemId = Item.func_150891_b((Item)this.inventory.getStackInSlot(1).func_77973_b());
        this.outputItemId = Item.func_150891_b((Item)this.inventory.getStackInSlot(2).func_77973_b());
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.paperItemId = tag.func_74762_e("PaperItemId");
        this.outputItemId = tag.func_74762_e("OutputItemId");
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        tag.func_74768_a("PaperItemId", this.paperItemId);
        tag.func_74768_a("OutputItemId", this.outputItemId);
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerTagWorkbench(windowId, inv, this.func_174877_v());
    }

    private class TagMatcherItemHandler
    extends TileEntityDisplayTable.DisplayItemHandler {
        TagMatcherItemHandler() {
            super(TileEntityTagWorkbench.this, TileEntityTagWorkbench.this, 3);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: {
                    return true;
                }
                case 1: {
                    return stack.func_77973_b() == Items.field_151121_aF || stack.func_77973_b() == ModItems.TAG_FILTER.get();
                }
                case 2: {
                    return stack.func_77973_b() == ModItems.TAG_FILTER.get();
                }
            }
            throw new IllegalArgumentException("invalid slot " + slot);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1) {
                TileEntityTagWorkbench.this.outputItemId = Item.func_150891_b((Item)this.getStackInSlot(1).func_77973_b());
            } else if (slot == 2) {
                TileEntityTagWorkbench.this.paperItemId = Item.func_150891_b((Item)this.getStackInSlot(2).func_77973_b());
            }
        }

        @Override
        public int getSlotLimit(int slot) {
            switch (slot) {
                case 0: 
                case 2: {
                    return 1;
                }
            }
            return 64;
        }
    }
}

