/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerVacuumPump;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityVacuumPump
extends TileEntityPneumaticBase
implements IRedstoneControlled,
IManoMeasurable,
INamedContainerProvider {
    @GuiSynced
    private final MachineAirHandler vacuumHandler = new MachineAirHandler(5.0f, 7.0f, 2000);
    private final LazyOptional<IAirHandlerMachine> vacuumCap = LazyOptional.of(() -> this.vacuumHandler);
    public int rotation;
    public int oldRotation;
    private int turnTimer = -1;
    @DescSynced
    public boolean turning = false;
    private int rotationSpeed;
    @GuiSynced
    public int redstoneMode;

    public TileEntityVacuumPump() {
        super((TileEntityType)ModTileEntities.VACUUM_PUMP.get(), 5.0f, 7.0f, 2000, 4);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            if (side == this.getVacuumSide()) {
                return PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY.orEmpty(cap, this.vacuumCap);
            }
            if (side != this.getInputSide() && side != null) {
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public Direction getInputSide() {
        return this.getVacuumSide().func_176734_d();
    }

    public Direction getVacuumSide() {
        return this.getRotation();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.turnTimer >= 0) {
                --this.turnTimer;
            }
            if (this.airHandler.getPressure() > 2.0f && this.vacuumHandler.getPressure() > -0.99f && this.redstoneAllows()) {
                if (this.turnTimer == -1) {
                    this.turning = true;
                }
                this.airHandler.addAir((int)(-10.0f * this.getSpeedUsageMultiplierFromUpgrades()));
                this.vacuumHandler.addAir((int)(-2.0f * this.getSpeedMultiplierFromUpgrades()));
                this.turnTimer = 40;
            }
            if (this.turnTimer == 0) {
                this.turning = false;
            }
            if (this.airHandler.getConnectedAirHandlers(this).isEmpty()) {
                this.airHandler.airLeak(this, this.getInputSide());
            }
            if (this.vacuumHandler.getConnectedAirHandlers(this).isEmpty()) {
                this.vacuumHandler.airLeak(this, this.getVacuumSide());
            }
        } else {
            this.oldRotation = this.rotation;
            this.rotationSpeed = this.turning ? Math.min(this.rotationSpeed + 1, 20) : Math.max(this.rotationSpeed - 1, 0);
            this.rotation += this.rotationSpeed;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("vacuum", (INBT)this.vacuumHandler.serializeNBT());
        tag.func_74757_a("turning", this.turning);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.vacuumHandler.deserializeNBT(tag.func_74775_l("vacuum"));
        this.turning = tag.func_74767_n("turning");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public void printManometerMessage(PlayerEntity player, List<ITextComponent> curInfo) {
        String input = PneumaticCraftUtils.roundNumberTo(this.airHandler.getPressure(), 1);
        String vac = PneumaticCraftUtils.roundNumberTo(this.vacuumHandler.getPressure(), 1);
        curInfo.add(PneumaticCraftUtils.xlate("message.vacuum_pump.manometer", input, vac).func_211708_a(TextFormatting.GREEN));
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerVacuumPump(i, playerInventory, this.func_174877_v());
    }
}

