/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DatapackHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int JSON_EXTENSION_LENGTH = ".json".length();

    public static Map<ResourceLocation, JsonObject> loadJSONFiles(IResourceManager resourceManager, String folder, String tag) {
        LinkedHashMap<ResourceLocation, JsonObject> map = new LinkedHashMap<ResourceLocation, JsonObject>();
        for (ResourceLocation file : resourceManager.func_199003_a(folder, r -> r.endsWith(".json"))) {
            String path = file.func_110623_a();
            ResourceLocation id = new ResourceLocation(file.func_110624_b(), path.substring(folder.length() + 1, path.length() - JSON_EXTENSION_LENGTH));
            try {
                IResource iresource = resourceManager.func_199002_a(file);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonObject jsonobject = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonobject != null) {
                                if (jsonobject.size() == 0) {
                                    Log.debug("skipped %s: %s (empty JSON object)", tag, id);
                                    map.remove(id);
                                    continue;
                                }
                                JsonObject j = map.put(id, jsonobject);
                                Log.debug("loaded %s: %s", tag, id);
                                if (j == null) continue;
                                Log.error("duplicate %s discovered with ID %s", tag, id);
                                continue;
                            }
                            Log.error("can't load %s '%s' from %s - null JSON object?", tag, id, file);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                Log.error("can't parse %s '%s' (%s) - stack trace follows:", tag, file, e.getMessage());
                Log.error(ExceptionUtils.getStackTrace((Throwable)e), new Object[0]);
            }
        }
        return map;
    }
}

