/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;

public class NBTToJsonConverter {
    private final CompoundNBT tag;

    public NBTToJsonConverter(CompoundNBT tag) {
        this.tag = tag;
    }

    public String convert(boolean pretty) {
        JsonObject json = NBTToJsonConverter.getObject(this.tag);
        String jsonString = json.toString();
        JsonParser parser = new JsonParser();
        GsonBuilder builder = new GsonBuilder();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        JsonElement el = parser.parse(jsonString);
        return gson.toJson(el);
    }

    public static JsonObject getObject(CompoundNBT tag) {
        Set keys = tag.func_150296_c();
        JsonObject jsonRoot = new JsonObject();
        for (String key : keys) {
            JsonArray array;
            JsonObject keyObject = new JsonObject();
            jsonRoot.add(key, (JsonElement)keyObject);
            INBT nbt = tag.func_74781_a(key);
            keyObject.addProperty("type", (Number)nbt.func_74732_a());
            if (nbt instanceof CompoundNBT) {
                keyObject.add("value", (JsonElement)NBTToJsonConverter.getObject((CompoundNBT)nbt));
                continue;
            }
            if (nbt instanceof NumberNBT) {
                keyObject.addProperty("value", (Number)((NumberNBT)nbt).func_150286_g());
                continue;
            }
            if (nbt instanceof StringNBT) {
                keyObject.addProperty("value", ((StringNBT)nbt).func_150285_a_());
                continue;
            }
            if (nbt instanceof ListNBT) {
                array = new JsonArray();
                ListNBT tagList = (ListNBT)nbt;
                for (int i = 0; i < tagList.size(); ++i) {
                    array.add((JsonElement)NBTToJsonConverter.getObject(tagList.func_150305_b(i)));
                }
                keyObject.add("value", (JsonElement)array);
                continue;
            }
            if (nbt instanceof IntArrayNBT) {
                array = new JsonArray();
                IntArrayNBT intArray = (IntArrayNBT)nbt;
                for (int i : intArray.func_150302_c()) {
                    array.add((JsonElement)new JsonPrimitive((Number)i));
                }
                keyObject.add("value", (JsonElement)array);
                continue;
            }
            throw new IllegalArgumentException("NBT to JSON converter doesn't support the nbt tag: " + INBT.field_82578_b[nbt.func_74732_a()] + ", tag: " + nbt);
        }
        return jsonRoot;
    }
}

