/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.datagen.loot.TileEntitySerializerFunction;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.CopyName;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class ModLootTablesProvider
extends LootTableProvider {
    public ModLootTablesProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockLootTablePNC(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new ChestLootTablePNC(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationResults validationresults) {
    }

    public String func_200397_b() {
        return "PneumaticCraft Loot Tables";
    }

    private class ChestLootTablePNC
    extends ChestLootTables {
        private ChestLootTablePNC() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder lootPool = LootPool.func_216096_a();
            lootPool.func_216046_a((IRandomRange)new ConstantRange(4)).func_216045_a(this.createEntry((IItemProvider)ModItems.COMPRESSED_IRON_INGOT.get(), 10, 4, 12)).func_216045_a(this.createEntry((IItemProvider)ModItems.AMADRON_TABLET.get(), 2, 1, 1)).func_216045_a(this.createEntry((IItemProvider)ModItems.AIR_CANISTER.get(), 10, 1, 5)).func_216045_a(this.createEntry((IItemProvider)ModItems.PNEUMATIC_CYLINDER.get(), 5, 2, 4)).func_216045_a(this.createEntry((IItemProvider)ModItems.LOGISTICS_CORE.get(), 8, 4, 8)).func_216045_a(this.createEntry((IItemProvider)ModItems.CAPACITOR.get(), 4, 4, 8)).func_216045_a(this.createEntry((IItemProvider)ModItems.TRANSISTOR.get(), 4, 4, 8)).func_216045_a(this.createEntry((IItemProvider)ModItems.TURBINE_ROTOR.get(), 5, 2, 4)).func_216045_a(this.createEntry((IItemProvider)ModBlocks.COMPRESSED_IRON_BLOCK.get(), 2, 1, 2)).func_216045_a(this.createEntry((IItemProvider)ModBlocks.VORTEX_TUBE.get(), 5, 1, 1)).func_216045_a(this.createEntry((IItemProvider)ModBlocks.PRESSURE_TUBE.get(), 10, 3, 8)).func_216045_a(this.createEntry((IItemProvider)ModBlocks.ADVANCED_PRESSURE_TUBE.get(), 4, 3, 8)).func_216045_a(this.createEntry((IItemProvider)ModBlocks.HEAT_PIPE.get(), 8, 3, 8)).func_216045_a(this.createEntry((IItemProvider)ModBlocks.APHORISM_TILE.get(), 5, 2, 3));
            LootTable.Builder lootTable = LootTable.func_216119_b();
            lootTable.func_216040_a(lootPool);
            consumer.accept(PneumaticCraftUtils.RL("chests/mechanic_house"), lootTable);
        }

        private LootEntry.Builder<?> createEntry(IItemProvider item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), weight).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max)));
        }

        private StandaloneLootEntry.Builder<?> createEntry(ItemStack item, int weight) {
            StandaloneLootEntry.Builder ret = ItemLootEntry.func_216168_a((IItemProvider)item.func_77973_b()).func_216086_a(weight);
            if (item.func_77942_o()) {
                ret.func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)item.func_196082_o()));
            }
            return ret;
        }
    }

    private static class BlockLootTablePNC
    extends BlockLootTables {
        private BlockLootTablePNC() {
        }

        protected void addTables() {
            for (RegistryObject ro : ModBlocks.BLOCKS.getEntries()) {
                Block b = (Block)ro.get();
                if (b instanceof BlockPneumaticCraft && b.hasTileEntity(b.func_176223_P()) && ForgeRegistries.ITEMS.containsKey(b.getRegistryName())) {
                    this.addStandardSerializedDrop(b);
                    continue;
                }
                if (b == ModBlocks.REINFORCED_BRICK_SLAB.get() || b == ModBlocks.REINFORCED_STONE_SLAB.get()) {
                    this.func_218522_a(b, BlockLootTables::func_218513_d);
                    continue;
                }
                if (b.func_199767_j() == Items.field_190931_a) continue;
                this.func_218492_c(b);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> l = new ArrayList<Block>();
            for (RegistryObject ro : ModBlocks.BLOCKS.getEntries()) {
                if (!ForgeRegistries.ITEMS.containsKey(((Block)ro.get()).getRegistryName())) continue;
                l.add((Block)ro.get());
            }
            return l;
        }

        private void addStandardSerializedDrop(Block block) {
            LootPool.Builder builder = LootPool.func_216096_a().name(block.getRegistryName().func_110623_a()).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_(TileEntitySerializerFunction.builder()));
            this.func_218507_a(block, LootTable.func_216119_b().func_216040_a(builder));
        }
    }
}

