/*
 * Decompiled with CFR 0.152.
 */
package com.github.xevinaly.portablelightsources.events;

import com.github.xevinaly.portablelightsources.PortableLightSources;
import com.github.xevinaly.portablelightsources.blocks.AirLightSource;
import com.github.xevinaly.portablelightsources.blocks.WaterLightSource;
import com.github.xevinaly.portablelightsources.init.ModBlocks;
import com.github.xevinaly.portablelightsources.util.DelayedCall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="portablelightsources", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PortableLightEvent {
    private static final Map<World, Map<Entity, LocationData>> worldEntityLocationData = new ConcurrentHashMap<World, Map<Entity, LocationData>>();
    private static final Map<Item, LightSource> itemLightSources = new HashMap<Item, LightSource>();
    private static final List<BlockState> replaceableBlockStates = new ArrayList<BlockState>();
    private static final List<Block> lightSourceBlocks = new ArrayList<Block>();
    private static final List<EntityType<?>> brightEntities = new ArrayList();
    private static final List<EntityType<?>> untrackedEntities = new ArrayList();

    @SubscribeEvent
    public static void parseTags(WorldEvent.Load event) {
        if (itemLightSources.size() == 0) {
            replaceableBlockStates.add(Blocks.field_150350_a.func_176223_P());
            replaceableBlockStates.add(Blocks.field_201941_jj.func_176223_P());
            replaceableBlockStates.add(Blocks.field_201940_ji.func_176223_P());
            replaceableBlockStates.add(Blocks.field_150355_j.func_176223_P());
            replaceableBlockStates.add(Fluids.field_204546_a.func_207207_a(8, false).func_206883_i());
            replaceableBlockStates.add(Fluids.field_204546_a.func_207207_a(8, true).func_206883_i());
            for (int i = 1; i <= 15; ++i) {
                replaceableBlockStates.add(((AirLightSource)ModBlocks.AIR_LIGHT_SOURCE.get()).getStateWithLightValue(i));
                replaceableBlockStates.add(((WaterLightSource)ModBlocks.WATER_LIGHT_SOURCE.get()).getStateWithLightValue(i));
            }
            lightSourceBlocks.addAll(BlockTags.func_199896_a().func_199910_a(new ResourceLocation("portablelightsources", "light_sources")).func_199885_a());
            brightEntities.addAll(EntityTypeTags.func_219762_a().func_199910_a(new ResourceLocation("portablelightsources", "bright_entities")).func_199885_a());
            untrackedEntities.addAll(EntityTypeTags.func_219762_a().func_199910_a(new ResourceLocation("portablelightsources", "untracked_entities")).func_199885_a());
            ArrayList airOnly = new ArrayList();
            ArrayList waterOnly = new ArrayList();
            waterOnly.addAll(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("portablelightsources", "portable_light_water")).func_199885_a());
            airOnly.addAll(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("portablelightsources", "portable_light_air")).func_199885_a());
            for (int lightValue = 1; lightValue <= 15; ++lightValue) {
                try {
                    for (Item item : ItemTags.func_199903_a().func_199910_a(new ResourceLocation("portablelightsources", "portable_light_" + lightValue)).func_199885_a()) {
                        Medium restrictedMedium = Medium.NONE;
                        if (airOnly.contains(item)) {
                            restrictedMedium = Medium.WATER;
                        }
                        if (waterOnly.contains(item)) {
                            restrictedMedium = Medium.AIR;
                        }
                        itemLightSources.put(item, new LightSource(lightValue, restrictedMedium));
                    }
                    continue;
                }
                catch (Exception exception) {
                    PortableLightSources.LOGGER.info("There are no portable light sources with a light value of " + lightValue);
                }
            }
        }
    }

    @SubscribeEvent
    public static void resetEntityLocationData(WorldEvent.Unload event) {
        World world;
        if (event.getWorld() instanceof World && (world = (World)event.getWorld()) != null && worldEntityLocationData.containsKey(world)) {
            for (Map.Entry<Entity, LocationData> entry : worldEntityLocationData.get(world).entrySet()) {
                entry.getValue().reset();
            }
            worldEntityLocationData.replace(world, new ConcurrentHashMap());
        }
    }

    @SubscribeEvent
    public static void registerEntity(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (!worldEntityLocationData.containsKey(world)) {
            worldEntityLocationData.put(world, new ConcurrentHashMap());
        }
        if (untrackedEntities.contains(entity.func_200600_R()) || entity instanceof ItemEntity && !itemLightSources.containsKey(((ItemEntity)entity).func_92059_d().func_77973_b())) {
            return;
        }
        worldEntityLocationData.get(world).put(entity, new LocationData());
    }

    @SubscribeEvent
    public static void checkEntityLocationAndLightStatus(TickEvent.WorldTickEvent event) {
        World world = event.world;
        Map<Entity, LocationData> entityLocationData = worldEntityLocationData.get(world);
        if (entityLocationData != null) {
            Iterator<Map.Entry<Entity, LocationData>> entrySet = entityLocationData.entrySet().iterator();
            while (entrySet.hasNext()) {
                Map.Entry<Entity, LocationData> entry = entrySet.next();
                Entity entity = entry.getKey();
                LocationData data = entry.getValue();
                if (entity.field_70128_L) {
                    data.reset();
                    entrySet.remove();
                    continue;
                }
                int lightValue = PortableLightEvent.greatestLightSourceOnEntity(entity, world);
                if (lightValue != 0) {
                    BlockPos blockToLight = PortableLightEvent.getClosestReplaceableBlock(entity, world);
                    BlockState originalBlockState = world.func_180495_p(blockToLight);
                    BlockState newBlockState = PortableLightEvent.getLitBlockState(lightValue, originalBlockState);
                    if (lightSourceBlocks.contains(originalBlockState.func_177230_c())) {
                        data.add(blockToLight, () -> {
                            if (newBlockState.func_177230_c() instanceof AirLightSource) {
                                if (world.func_180495_p(blockToLight.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                                    world.func_175656_a(blockToLight, Blocks.field_150350_a.func_176223_P());
                                } else {
                                    world.func_175656_a(blockToLight, Blocks.field_201941_jj.func_176223_P());
                                }
                            } else if (world.func_180495_p(blockToLight.func_177984_a()).func_196958_f()) {
                                world.func_175656_a(blockToLight, Blocks.field_150355_j.func_176223_P());
                            } else {
                                world.func_175656_a(blockToLight, Fluids.field_204546_a.func_207207_a(8, false).func_206883_i());
                            }
                        });
                    } else {
                        data.add(blockToLight, () -> world.func_175656_a(blockToLight, originalBlockState));
                    }
                    if (lightValue <= world.func_217298_h(blockToLight) && !(entity instanceof PlayerEntity)) continue;
                    world.func_175656_a(blockToLight, newBlockState);
                    continue;
                }
                data.reset();
            }
        }
    }

    private static int greatestLightSourceOnEntity(Entity entity, World world) {
        int lightValue = 0;
        if (entity.func_223314_ad() > 0) {
            return 15;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Block blockToReplace = world.func_180495_p(PortableLightEvent.getClosestReplaceableBlock(entity, world)).func_177230_c();
            for (ItemStack itemStack : player.func_184214_aD()) {
                if (!itemLightSources.containsKey(itemStack.func_77973_b())) continue;
                LightSource item = itemLightSources.get(itemStack.func_77973_b());
                if (item.lightValue <= lightValue || item.restrictedMedium == PortableLightEvent.getMedium(blockToReplace)) continue;
                lightValue = item.lightValue;
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Block blockToReplace = world.func_180495_p(PortableLightEvent.getClosestReplaceableBlock(entity, world)).func_177230_c();
            if (itemLightSources.containsKey(itemEntity.func_92059_d().func_77973_b())) {
                LightSource item = itemLightSources.get(itemEntity.func_92059_d().func_77973_b());
                if (item.lightValue > lightValue && item.restrictedMedium != PortableLightEvent.getMedium(blockToReplace)) {
                    lightValue = item.lightValue;
                }
            }
        } else if (brightEntities.contains(entity.func_200600_R())) {
            return 15;
        }
        return lightValue;
    }

    private static Medium getMedium(Block blockToReplace) {
        if (blockToReplace == Blocks.field_201941_jj || blockToReplace == Blocks.field_150350_a || blockToReplace == ModBlocks.AIR_LIGHT_SOURCE.get()) {
            return Medium.AIR;
        }
        if (blockToReplace == Blocks.field_150355_j) {
            return Medium.WATER;
        }
        return Medium.VOID;
    }

    private static BlockPos getClosestReplaceableBlock(Entity entity, World world) {
        BlockPos position = entity.func_180425_c();
        if ((double)entity.func_213302_cg() > 1.2) {
            position = position.func_177982_a(0, 1, 0);
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position))) {
            return position;
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a()))) {
            return position.func_177984_a();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b()))) {
            return position.func_177977_b();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177974_f()))) {
            return position.func_177974_f();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177976_e()))) {
            return position.func_177976_e();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177978_c()))) {
            return position.func_177978_c();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177968_d()))) {
            return position.func_177968_d();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177974_f()))) {
            return position.func_177984_a().func_177974_f();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177976_e()))) {
            return position.func_177984_a().func_177976_e();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177978_c()))) {
            return position.func_177984_a().func_177978_c();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177968_d()))) {
            return position.func_177984_a().func_177968_d();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177978_c()))) {
            return position.func_177977_b().func_177978_c();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177974_f()))) {
            return position.func_177977_b().func_177974_f();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177968_d()))) {
            return position.func_177977_b().func_177968_d();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177976_e()))) {
            return position.func_177977_b().func_177976_e();
        }
        return position;
    }

    private static BlockState getLitBlockState(int lightValue, BlockState originalBlockState) {
        Block blockToReplace = originalBlockState.func_177230_c();
        if (blockToReplace == Blocks.field_201941_jj || blockToReplace == Blocks.field_150350_a || blockToReplace == ModBlocks.AIR_LIGHT_SOURCE.get()) {
            return ((AirLightSource)ModBlocks.AIR_LIGHT_SOURCE.get()).getStateWithLightValue(lightValue);
        }
        if (blockToReplace == Blocks.field_150355_j) {
            return ((WaterLightSource)ModBlocks.WATER_LIGHT_SOURCE.get()).getStateWithLightValue(lightValue);
        }
        return originalBlockState;
    }

    private static class LocationData {
        private final List<BlockData> litBlocks = new ArrayList<BlockData>();

        public void add(BlockPos position, DelayedCall resetMethod) {
            switch (this.getDuplicateLocation(position)) {
                case FIRST: {
                    this.swapElements();
                    break;
                }
                case SECOND: {
                    break;
                }
                default: {
                    this.add(new BlockData(position, resetMethod));
                }
            }
        }

        private void swapElements() {
            if (this.litBlocks.size() > 1) {
                BlockData data = this.litBlocks.get(0);
                this.litBlocks.remove(0);
                this.litBlocks.add(data);
            }
        }

        private void add(BlockData data) {
            if (this.litBlocks.size() == 2) {
                this.removeFirstElement();
            }
            this.litBlocks.add(data);
        }

        private void removeFirstElement() {
            this.litBlocks.get((int)0).resetMethod.delayedCall();
            this.litBlocks.remove(0);
        }

        private DuplicateLocation getDuplicateLocation(BlockPos position) {
            if (this.litBlocks.size() == 2 && this.isDuplicate(position, this.litBlocks.get((int)0).position)) {
                return DuplicateLocation.FIRST;
            }
            if (this.litBlocks.size() > 1 && this.isDuplicate(position, this.litBlocks.get((int)1).position)) {
                return DuplicateLocation.SECOND;
            }
            return DuplicateLocation.NEITHER;
        }

        private boolean isDuplicate(BlockPos A, BlockPos B) {
            return A.func_177958_n() == B.func_177958_n() && A.func_177956_o() == B.func_177956_o() && A.func_177952_p() == B.func_177952_p();
        }

        public void reset() {
            for (BlockData data : this.litBlocks) {
                data.resetMethod.delayedCall();
            }
        }

        private static enum DuplicateLocation {
            FIRST,
            SECOND,
            NEITHER;

        }

        private static class BlockData {
            BlockPos position;
            DelayedCall resetMethod;

            public BlockData(BlockPos position, DelayedCall resetMethod) {
                this.position = position;
                this.resetMethod = resetMethod;
            }
        }
    }

    private static enum Medium {
        AIR,
        WATER,
        VOID,
        NONE;

    }

    private static class LightSource {
        int lightValue;
        Medium restrictedMedium;

        public LightSource(int lightValue, Medium restrictedMedium) {
            this.lightValue = lightValue;
            this.restrictedMedium = restrictedMedium;
        }
    }
}

