/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.powder_power.items.armor;

import com.kwpugh.powder_power.init.ItemInit;
import com.kwpugh.powder_power.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorGemium
extends ArmorItem {
    public ArmorGemium(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (player instanceof PlayerEntity) {
            ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
            ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
            ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
            if (head.func_77973_b() == ItemInit.ARMOR_GEMIUM_HEAD.get() && chest.func_77973_b() == ItemInit.ARMOR_GEMIUM_BODY.get() && legs.func_77973_b() == ItemInit.ARMOR_GEMIUM_LEGGINGS.get() && feet.func_77973_b() == ItemInit.ARMOR_GEMIUM_BOOTS.get()) {
                player.func_184596_c(Effects.field_76436_u);
                player.func_184596_c(Effects.field_82731_v);
            }
            if (head.func_77973_b() == ItemInit.ARMOR_GEMIUM_HEAD.get()) {
                int newfoodlevel = 1;
                float newsatlevel = 0.3f;
                PlayerSpecialAbilities.giveRegenffect(world, player, stack, newfoodlevel, newsatlevel);
            }
            if (chest.func_77973_b() == ItemInit.ARMOR_GEMIUM_BODY.get()) {
                // empty if block
            }
            if (legs.func_77973_b() == ItemInit.ARMOR_GEMIUM_LEGGINGS.get()) {
                // empty if block
            }
            if (feet.func_77973_b() == ItemInit.ARMOR_GEMIUM_BOOTS.get()) {
                // empty if block
            }
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GEM_GEMIUM.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.powder_power.armor_gemium_full.line1", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.powder_power.armor_gemium_full.line2", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.powder_power.armor_gemium_full.line3", new Object[0]).func_211708_a(TextFormatting.GREEN));
    }
}

