/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.powder_power.util;

import com.kwpugh.powder_power.init.ItemInit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;

public class CuriosDragonToken {
    public static ICapabilityProvider initCapabilities() {
        final ICurio curio = new ICurio(){

            public boolean canRightClickEquip() {
                return true;
            }

            public void onEquipped(String identifier, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    this.startFlying((PlayerEntity)livingEntity);
                }
            }

            public void onUnequipped(String identifier, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    this.stopFlying((PlayerEntity)livingEntity);
                }
            }

            private void startFlying(PlayerEntity player) {
                if (!player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                }
            }

            private void stopFlying(PlayerEntity player) {
                if (!player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75101_c = false;
                    player.func_71016_p();
                }
            }

            public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    if (!player.field_71075_bZ.field_75101_c) {
                        this.startFlying(player);
                    }
                }
            }

            public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
                return !CuriosAPI.getCurioEquipped((Item)((Item)ItemInit.TOKEN_DRAGON.get()), (LivingEntity)entityLivingBase).isPresent();
            }

            public void playEquipSound(LivingEntity entityLivingBase) {
                entityLivingBase.field_70170_p.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187525_aO, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack token, LivingEntity player) {
        return CuriosAPI.getCurioEquipped((Item)token.func_77973_b(), (LivingEntity)player).isPresent();
    }
}

