/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.powder_power.util;

import com.kwpugh.powder_power.util.ConfigPowderPower;
import com.kwpugh.powder_power.util.PlayerEquipUtil;
import net.minecraft.block.OreBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="powder_power", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    static int miningExp = (Integer)ConfigPowderPower.exp_token_mining_value.get();
    static int killingExp = (Integer)ConfigPowderPower.exp_token_killing_value.get();

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getSource() == DamageSource.field_76379_h && PlayerEquipUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76371_c) && PlayerEquipUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.field_76369_e && PlayerEquipUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        PlayerEntity player;
        if (event.getAttackingPlayer() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity && PlayerEquipUtil.isPlayerGotExpToken(player = event.getAttackingPlayer())) {
            int orgExp = event.getOriginalExperience();
            int newExp = orgExp * killingExp;
            event.setDroppedExperience(newExp);
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player;
        if (event.getState().func_177230_c() instanceof OreBlock && event.getPlayer() instanceof PlayerEntity && PlayerEquipUtil.isPlayerGotExpToken(player = event.getPlayer())) {
            event.setExpToDrop(miningExp);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity attacker = (MobEntity)event.getEntityLiving();
            if (PlayerEquipUtil.isPlayerGotUnseenToken(player) && attacker instanceof PhantomEntity) {
                attacker.func_70624_b(null);
            }
            if (PlayerEquipUtil.isPlayerGotUnseenTokenInHand(player)) {
                attacker.func_70624_b(null);
            }
        }
    }
}

