/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.client.crafting;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tschipp.primitivecrafting.PrimitiveCrafting;
import tschipp.primitivecrafting.common.crafting.IPrimitiveRecipe;
import tschipp.primitivecrafting.network.Craft;

public class CraftingAction {
    private List<IPrimitiveRecipe> validRecipes;
    private IPrimitiveRecipe currentRecipe;
    private ItemStack creationHeld;
    private ItemStack creationInv;
    private Slot inventorySlot;

    public CraftingAction(List<IPrimitiveRecipe> validRecipes, IPrimitiveRecipe currentRecipe, ItemStack creationHeld, ItemStack creationInv, Slot invSlot, @Nullable CraftingAction old) {
        this.validRecipes = validRecipes;
        this.currentRecipe = currentRecipe;
        this.creationHeld = creationHeld;
        this.creationInv = creationInv;
        this.inventorySlot = invSlot;
        if (old != null && validRecipes.contains(old.currentRecipe)) {
            this.currentRecipe = old.currentRecipe;
        }
    }

    public void craft(ItemStack held, ItemStack inventoryStack, boolean craftMax, int slot) {
        int craftAmount = 1;
        if (craftMax) {
            craftAmount = CraftingAction.getTimesCrafted(held, inventoryStack, this.currentRecipe)[0];
        }
        for (int i = 0; i < craftAmount && this.currentRecipe.isValid(held, inventoryStack); ++i) {
            PrimitiveCrafting.network.sendToServer((IMessage)new Craft(held, this.currentRecipe, slot));
            this.currentRecipe.craft(held, inventoryStack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, held, slot);
        }
    }

    public List<IPrimitiveRecipe> getValidRecipes() {
        return this.validRecipes;
    }

    public void setCurrentRecipe(IPrimitiveRecipe recipe) {
        this.currentRecipe = recipe;
    }

    public IPrimitiveRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public Slot getSlot() {
        return this.inventorySlot;
    }

    public boolean isSame(ItemStack held, ItemStack inventory) {
        return held == this.creationHeld && inventory == this.creationInv;
    }

    public static int[] getTimesCrafted(ItemStack stackA, ItemStack stackB, IPrimitiveRecipe recipe) {
        ItemStack a = stackA.func_77946_l();
        ItemStack b = stackB.func_77946_l();
        int craftAmount = 0;
        for (int i = 0; i < 64 && recipe.isValid(a, b); ++i) {
            recipe.craft(a, b, null, a, 0);
            ++craftAmount;
        }
        int aCount = stackA.func_190916_E() - a.func_190916_E();
        int bCount = stackB.func_190916_E() - b.func_190916_E();
        return new int[]{craftAmount, aCount == 0 ? 1 : aCount, bCount == 0 ? 1 : bCount};
    }
}

