/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.item.SpawnEgg;
import cy.jdkdigital.productivebees.setup.ClientProxy;
import cy.jdkdigital.productivebees.setup.ClientSetup;
import cy.jdkdigital.productivebees.setup.IProxy;
import cy.jdkdigital.productivebees.setup.ServerProxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="productivebees")
@Mod.EventBusSubscriber(modid="productivebees")
public final class ProductiveBees {
    public static final String MODID = "productivebees";
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final Logger LOGGER = LogManager.getLogger();

    public ProductiveBees() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.HIVE_BEES.register(modEventBus);
        ModEntities.SOLITARY_BEES.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModPointOfInterestTypes.POINT_OF_INTEREST_TYPES.register(modEventBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::registerItemColors);
            modEventBus.addListener(EventPriority.LOWEST, this::registerBlockColors);
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
        });
        modEventBus.addListener(ClientSetup::init);
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::loadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ProductiveBeesConfig.CONFIG);
        ProductiveBeesConfig.loadConfig(ProductiveBeesConfig.CONFIG, FMLPaths.CONFIGDIR.get().resolve("productivebees-server.toml").toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        ModEntities.registerRendering();
        ModBlocks.registerRendering();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        for (RegistryObject<Item> items : ModItems.SPAWN_EGGS) {
            Item item;
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, items, (String)"value") == null || !((item = (Item)items.get()) instanceof SpawnEgg)) continue;
            event.getItemColors().func_199877_a((itemColor, itemsIn) -> ((SpawnEgg)item).func_195983_a(itemsIn), new IItemProvider[]{item});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((blockState, lightReader, pos, i) -> lightReader != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)lightReader, (BlockPos)pos) : -1, new Block[]{(Block)ModBlocks.SUGAR_CANE_NEST.get()});
    }

    public void preInit(FMLCommonSetupEvent event) {
        CapabilityBee.register();
        this.fixPOI(event);
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            Biome.Category category = biome.func_201856_r();
            if (category.equals((Object)Biome.Category.DESERT)) {
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.SAND_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150354_m.func_176223_P(), ((Block)ModBlocks.SAND_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.SAVANNA) || category.equals((Object)Biome.Category.TAIGA)) {
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.COARSE_DIRT_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196660_k.func_176223_P(), ((Block)ModBlocks.COARSE_DIRT_NEST.get()).func_176223_P())));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.SPRUCE_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196618_L.func_176223_P(), ((Block)ModBlocks.SPRUCE_WOOD_NEST.get()).func_176223_P())));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.ACACIA_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196621_O.func_176223_P(), ((Block)ModBlocks.ACACIA_WOOD_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.JUNGLE)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.JUNGLE_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196620_N.func_176223_P(), ((Block)ModBlocks.JUNGLE_WOOD_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.FOREST)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.OAK_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196617_K.func_176223_P(), ((Block)ModBlocks.OAK_WOOD_NEST.get()).func_176223_P())));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.DARK_OAK_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196623_P.func_176223_P(), ((Block)ModBlocks.DARK_OAK_WOOD_NEST.get()).func_176223_P())));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.BIRCH_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196619_M.func_176223_P(), ((Block)ModBlocks.BIRCH_WOOD_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.EXTREME_HILLS)) {
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.STONE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), ((Block)ModBlocks.STONE_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.SWAMP)) {
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.SLIMY_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196658_i.func_176223_P(), ((Block)ModBlocks.SLIMY_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.NETHER)) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)ModFeatures.GLOWSTONE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150426_aN.func_176223_P(), ((Block)ModBlocks.GLOWSTONE_NEST.get()).func_176223_P())));
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, ((Feature)ModFeatures.NETHER_QUARTZ_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196766_fg.func_176223_P(), ((Block)ModBlocks.NETHER_QUARTZ_NEST.get()).func_176223_P())));
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.NETHER_FORTRESS_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196653_dH.func_176223_P(), ((Block)ModBlocks.NETHER_BRICK_NEST.get()).func_176223_P())));
            } else if (category.equals((Object)Biome.Category.RIVER) || category.equals((Object)Biome.Category.BEACH)) {
                if (biome.func_150561_m() != Biome.TempCategory.COLD) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.GRAVEL_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150351_n.func_176223_P(), ((Block)ModBlocks.GRAVEL_NEST.get()).func_176223_P())));
                }
            } else if (category.equals((Object)Biome.Category.THEEND)) {
                if (biome == Biomes.field_76779_k) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.OBSIDIAN_PILLAR_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150343_Z.func_176223_P(), ((Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get()).func_176223_P())));
                } else {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.END_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150377_bs.func_176223_P(), ((Block)ModBlocks.END_NEST.get()).func_176223_P())));
                }
            }
            if (category.equals((Object)Biome.Category.THEEND) || category.equals((Object)Biome.Category.NETHER)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.SUGAR_CANE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196608_cF.func_176223_P(), ((Block)ModBlocks.SUGAR_CANE_NEST.get()).func_176223_P())));
        }
    }

    private void fixPOI(FMLCommonSetupEvent event) {
        for (RegistryObject poi : ModPointOfInterestTypes.POINT_OF_INTEREST_TYPES.getEntries()) {
            ModPointOfInterestTypes.fixPOITypeBlockStates((PointOfInterestType)poi.get());
        }
        ImmutableList BEEHIVES = ImmutableList.of((Object)ModBlocks.OAK_WOOD_NEST.get(), (Object)ModBlocks.SPRUCE_WOOD_NEST.get(), (Object)ModBlocks.DARK_OAK_WOOD_NEST.get(), (Object)ModBlocks.JUNGLE_WOOD_NEST.get(), (Object)ModBlocks.BIRCH_WOOD_NEST.get(), (Object)ModBlocks.ACACIA_WOOD_NEST.get(), (Object)ModBlocks.BAMBOO_HIVE.get(), (Object)ModBlocks.STONE_NEST.get(), (Object)ModBlocks.SAND_NEST.get(), (Object)ModBlocks.COARSE_DIRT_NEST.get(), (Object)ModBlocks.GRAVEL_NEST.get(), (Object)ModBlocks.SUGAR_CANE_NEST.get(), (Object[])new Block[]{(Block)ModBlocks.SLIMY_NEST.get(), (Block)ModBlocks.GLOWSTONE_NEST.get(), (Block)ModBlocks.NETHER_QUARTZ_NEST.get(), (Block)ModBlocks.NETHER_BRICK_NEST.get(), (Block)ModBlocks.END_NEST.get(), (Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get(), (Block)ModBlocks.DRAGON_EGG_HIVE.get(), (Block)ModBlocks.ADVANCED_OAK_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_SPRUCE_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BIRCH_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_JUNGLE_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_ACACIA_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_DARK_OAK_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_CRIMSON_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_WARPED_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_SNAKE_BLOCK_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_ROSEWOOD_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_YUCCA_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_KOUSA_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_ASPEN_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_GRIMWOOD_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_WILLOW_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_WISTERIA_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BAMBOO_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_MAPLE_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_DRIFTWOOD_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_RIVER_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_POISE_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_FIR_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_DEAD_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_PALM_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_MAGIC_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_CHERRY_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_UMBRAN_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_WILLOW_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_REDWOOD_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_HELLBARK_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_MAHOGANY_BEEHIVE.get(), (Block)ModBlocks.ADVANCED_BOP_JACARANDA_BEEHIVE.get()});
        HashSet newSet = new HashSet(TileEntityType.field_226985_G_.field_223046_I);
        newSet.addAll(BEEHIVES);
        TileEntityType.field_226985_G_.field_223046_I = newSet;
        PointOfInterestType.field_226356_s_.field_221075_w = (Set)BlockTags.field_226151_aa_.func_199885_a().stream().flatMap(map -> map.func_176194_O().func_177619_a().stream()).collect(ImmutableSet.toImmutableSet());
        HashMap<BlockState, PointOfInterestType> map2 = new HashMap<BlockState, PointOfInterestType>();
        ProductiveBees.addToMap(Blocks.field_226906_mb_, map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_OAK_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_SPRUCE_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BIRCH_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_JUNGLE_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_ACACIA_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_DARK_OAK_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_CRIMSON_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_WARPED_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_SNAKE_BLOCK_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_ROSEWOOD_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_YUCCA_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_KOUSA_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_ASPEN_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_GRIMWOOD_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_WILLOW_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_WISTERIA_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BAMBOO_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_MAPLE_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_DRIFTWOOD_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_RIVER_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_POISE_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_FIR_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_DEAD_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_PALM_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_MAGIC_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_CHERRY_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_UMBRAN_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_WILLOW_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_REDWOOD_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_HELLBARK_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_MAHOGANY_BEEHIVE.get(), map2);
        ProductiveBees.addToMap((Block)ModBlocks.ADVANCED_BOP_JACARANDA_BEEHIVE.get(), map2);
        PointOfInterestType.field_221073_u.putAll(map2);
    }

    public static void addToMap(Block block, Map<BlockState, PointOfInterestType> pointOfInterestTypeMap) {
        block.func_176194_O().func_177619_a().forEach(state -> pointOfInterestTypeMap.put((BlockState)state, PointOfInterestType.field_226356_s_));
    }
}

