/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.block;

import cy.jdkdigital.productivebees.tileentity.AdvancedBeehiveTileEntityAbstract;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AdvancedBeehiveAbstract
extends ContainerBlock {
    public static final Direction[] DIRECTIONS;
    protected static int MAX_HONEY_LEVEL;

    public AdvancedBeehiveAbstract(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH));
    }

    public int getMaxHoneyLevel() {
        return MAX_HONEY_LEVEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT entityNBT = stack.func_179543_a("BlockEntityTag");
        CompoundNBT stateNBT = stack.func_179543_a("BlockStateTag");
        if (stateNBT != null && stateNBT.func_74764_b("honey_level")) {
            String honeyLevel = stateNBT.func_74779_i("honey_level");
            tooltip.add(new TranslationTextComponent("productivebees.hive.tooltip.honey_level", new Object[]{honeyLevel}).func_211708_a(TextFormatting.GOLD));
        }
        if (entityNBT != null && entityNBT.func_74764_b("Bees")) {
            ListNBT beeList = entityNBT.func_74775_l("Bees").func_150295_c("Inhabitants", 10);
            if (beeList.size() > 0) {
                tooltip.add(new TranslationTextComponent("productivebees.hive.tooltip.bees", new Object[0]).func_211708_a(TextFormatting.BOLD));
                for (int i = 0; i < beeList.size(); ++i) {
                    CompoundNBT tag = beeList.func_150305_b(i);
                    CompoundNBT beeNBT = tag.func_74775_l("EntityData");
                    tooltip.add(new TranslationTextComponent("" + beeNBT.func_74779_i("id"), new Object[0]).func_211708_a(TextFormatting.GREEN));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.hive.tooltip.empty", new Object[0]));
            }
        }
    }

    public void takeHoney(World world, BlockState state, BlockPos pos) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(this.getMaxHoneyLevel() - 5)), 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_) >= MAX_HONEY_LEVEL) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                this.dripHoney(world, pos, state);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void dripHoney(World world, BlockPos pos, BlockState state) {
        VoxelShape shape;
        double shapeEnd;
        if (state.func_204520_s().func_206888_e() && world.field_73012_v.nextFloat() >= 0.3f && (shapeEnd = (shape = state.func_196952_d((IBlockReader)world, pos)).func_197758_c(Direction.Axis.Y)) >= 1.0 && !state.func_203425_a(BlockTags.field_211923_H)) {
            double shapeStart = shape.func_197762_b(Direction.Axis.Y);
            if (shapeStart > 0.0) {
                this.addHoneyParticle(world, pos, shape, (double)pos.func_177956_o() + shapeStart - 0.05);
            } else {
                BlockPos posDown = pos.func_177977_b();
                BlockState stateDown = world.func_180495_p(posDown);
                VoxelShape shapeDown = stateDown.func_196952_d((IBlockReader)world, posDown);
                double shapeDownEnd = shapeDown.func_197758_c(Direction.Axis.Y);
                if ((shapeDownEnd < 1.0 || !stateDown.func_224756_o((IBlockReader)world, posDown)) && stateDown.func_204520_s().func_206888_e()) {
                    this.addHoneyParticle(world, pos, shape, (double)pos.func_177956_o() - 0.05);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addHoneyParticle(World world, BlockPos pos, VoxelShape shape, double p_226880_4_) {
        this.addHoneyParticle(world, (double)pos.func_177958_n() + shape.func_197762_b(Direction.Axis.X), (double)pos.func_177958_n() + shape.func_197758_c(Direction.Axis.X), (double)pos.func_177952_p() + shape.func_197762_b(Direction.Axis.Z), (double)pos.func_177952_p() + shape.func_197758_c(Direction.Axis.Z), p_226880_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addHoneyParticle(World world, double d1, double d2, double d3, double d4, double d5) {
        world.func_195594_a((IParticleData)ParticleTypes.field_229427_ag_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)d1, (double)d2), d5, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)d3, (double)d4), 0.0, 0.0, 0.0);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BeehiveBlock.field_226873_c_, BlockStateProperties.field_208155_H});
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileEntity;
        if (!world.field_72995_K && player.func_184812_l_() && world.func_82736_K().func_223586_b(GameRules.field_223603_f) && (tileEntity = world.func_175625_s(pos)) instanceof AdvancedBeehiveTileEntityAbstract) {
            boolean hasBees;
            AdvancedBeehiveTileEntityAbstract beehiveTileEntity = (AdvancedBeehiveTileEntityAbstract)tileEntity;
            int honeyLevel = (Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
            boolean bl = hasBees = !beehiveTileEntity.func_226969_f_();
            if (!hasBees && honeyLevel == 0) {
                return;
            }
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            CompoundNBT compoundNBT = new CompoundNBT();
            if (hasBees) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("Inhabitants", (INBT)beehiveTileEntity.getBeeListAsNBTList());
                compoundNBT.func_218657_a("Bees", (INBT)nbt);
            }
            compoundNBT.func_74768_a("honey_level", honeyLevel);
            itemStack.func_77983_a("BlockStateTag", (INBT)compoundNBT);
            ItemEntity hiveEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
            hiveEntity.func_174869_p();
            world.func_217376_c((Entity)hiveEntity);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileEntity;
        Entity entity = (Entity)builder.func_216019_b(LootParameters.field_216281_a);
        if ((entity instanceof TNTEntity || entity instanceof CreeperEntity || entity instanceof WitherSkullEntity || entity instanceof WitherEntity || entity instanceof TNTMinecartEntity) && (tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h)) instanceof AdvancedBeehiveTileEntityAbstract) {
            AdvancedBeehiveTileEntityAbstract beehiveTileEntity = (AdvancedBeehiveTileEntityAbstract)tileEntity;
            beehiveTileEntity.func_226963_a_(null, state, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.func_220076_a(state, builder);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState state1, IWorld world, BlockPos pos, BlockPos fireBlockPos) {
        TileEntity tileEntity;
        if (world.func_180495_p(fireBlockPos).func_177230_c() instanceof FireBlock && (tileEntity = world.func_175625_s(pos)) instanceof AdvancedBeehiveTileEntityAbstract) {
            AdvancedBeehiveTileEntityAbstract beehiveTileEntity = (AdvancedBeehiveTileEntityAbstract)tileEntity;
            beehiveTileEntity.func_226963_a_(null, state, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.func_196271_a(state, direction, state1, world, pos, fireBlockPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    static {
        MAX_HONEY_LEVEL = 5;
        DIRECTIONS = new Direction[]{Direction.WEST, Direction.EAST, Direction.SOUTH};
    }
}

