/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.block;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.tileentity.SolitaryNestTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;

public class SolitaryNest
extends AdvancedBeehiveAbstract {
    public SolitaryNest(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH));
    }

    @Override
    public int getMaxHoneyLevel() {
        return 0;
    }

    public EntityType<BeeEntity> getNestingBeeType(World world) {
        ResourceLocation id = this.getRegistryName();
        IRecipe recipe = world.func_199532_z().func_215367_a(new ResourceLocation("productivebees", "bee_spawning/" + id.func_110623_a())).orElse(null);
        if (recipe instanceof BeeSpawningRecipe) {
            BeeSpawningRecipe spawningRecipe = (BeeSpawningRecipe)recipe;
            BeeIngredient bee = spawningRecipe.output.get(world.field_73012_v.nextInt(spawningRecipe.output.size()));
            return bee.getBeeType();
        }
        ProductiveBees.LOGGER.info("No bee spawning recipe found for " + id);
        return null;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.SOLITARY_NEST.get()).func_200968_a();
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new SolitaryNestTileEntity();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext itemUseContext) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)itemUseContext.func_196010_d().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, BeehiveBlock.field_226873_c_});
    }

    public boolean canRepopulateIn(Dimension dimension, Biome biome) {
        return dimension.func_76569_d();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.func_201670_d()) {
            SolitaryNestTileEntity tileEntity = (SolitaryNestTileEntity)world.func_175625_s(pos);
            ProductiveBees.LOGGER.debug("Nest tilentity: " + (Object)((Object)tileEntity));
            ProductiveBees.LOGGER.debug("Nest tilentity type: " + tileEntity.func_200662_C().getRegistryName());
            ProductiveBees.LOGGER.debug("Nest sealed: " + tileEntity.isSealed());
            ProductiveBees.LOGGER.debug("Bee count: " + tileEntity.getBeeList().size());
            ProductiveBees.LOGGER.debug("Occupants: " + tileEntity.getBeeList());
            ProductiveBees.LOGGER.debug("Egg count: " + tileEntity.getEggs().size());
            ProductiveBees.LOGGER.debug("Eggs: " + tileEntity.getEggListAsNBTList());
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }
}

