/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity;

import com.google.common.collect.Maps;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProductiveBeeRenderer
extends MobRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>> {
    Map<String, ResourceLocation> cachedResourceLocations = Maps.newHashMap();

    public ProductiveBeeRenderer(EntityRendererManager renderManagerIn, ProductiveBeeModel<ProductiveBeeEntity> model) {
        super(renderManagerIn, model, 0.7f);
    }

    public ProductiveBeeRenderer(EntityRendererManager renderManagerIn) {
        this(renderManagerIn, new ProductiveBeeModel<ProductiveBeeEntity>());
    }

    public ResourceLocation getEntityTexture(ProductiveBeeEntity bee) {
        String beeLocation = "bee/" + bee.getBeeType() + "/bee";
        if (bee.func_226427_ez_()) {
            beeLocation = beeLocation + "_angry";
        }
        if (bee.func_226411_eD_()) {
            beeLocation = beeLocation + "_nectar";
        }
        return this.getResLocation(beeLocation);
    }

    protected ResourceLocation getResLocation(String beeLocation) {
        if (!this.cachedResourceLocations.containsKey(beeLocation)) {
            this.cachedResourceLocations.put(beeLocation, new ResourceLocation("productivebees:textures/entity/" + beeLocation + ".png"));
        }
        return this.cachedResourceLocations.get(beeLocation);
    }
}

